// Interface.m
//--------------------------------------------------------------------

#import "Interface.h"

//--------------------------------------------------------------------

@implementation Interface

//--------------------------------------------------------------------

- setLengthOfGenoma: (int) gL
{

TRACE3(printf("\n%8X Interface - entry setLengthOfGenoma: %d\n",
              (int) self,gL);)

   lengthOfGenoma = gL;

TRACE3(printf("%8X Interface - exit setLengthOfGenoma %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- createEnd
{

   id obj;
   int i;

TRACE3(printf("\n%8X Interface - entry createEnd\n",(int) self);)

   for (i=0;i<lengthOfGenoma;i++)
   {

       genoma[i] = '0';
       if ([uniformIntRand getIntegerWithMin: 0 withMax: 1] == 1)
          genoma[i] = '1';

   }

   obj = [super createEnd];

TRACE3(printf("%8X Interface - exit createEnd %8X\n\n",(int) self,(int) obj);)

   return obj;

}

//--------------------------------------------------------------------

- setGenoma: (char *) ge
{

   int i;

TRACE3(printf("\n%8X Rule - entry setGenoma: %8X\n",(int) self,(int) ge);)

   for(i=0;i<lengthOfGenoma;i++) genoma[i] = ge[i];

TRACE3(printf("%8X Rule - exit setGenoma %8X\n\n",(int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setFitness: (float) fV
{

TRACE3(printf("\n%8X Rule - entry setFitness: %f\n",(int) self,fV);)

   fitness = fV;

TRACE3(printf("%8X Rule - exit setFitness %8X\n\n",(int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- (char *) getGenoma
{

TRACE3(printf("\n%8X Interface - entry getGenoma\n",(int) self);)
TRACE3(printf("%8X Interface - exit getGenoma %8X\n\n",
              (int) self,(int) &genoma[0]);)

   return &genoma[0];

}

//--------------------------------------------------------------------

- (float) getFitness
{

TRACE3(printf("\n%8X Interface - entry getFitness\n",(int) self);)
TRACE3(printf("%8X Interface - exit getFitness %f\n\n",
              (int) self,fitness);)

   return fitness;

}

//--------------------------------------------------------------------

- step
{

TRACE3(printf("\n%8X Interface - entry step\n",(int) self);)

   fitness = [uniformDblRand getDoubleWithMin: 0 withMax: 100];

TRACE3(printf("%8X Interface - exit step %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- print
{

   int i;

TRACE3(printf("\n%8X Interface - entry print\n",(int) self);)

   printf("\n %8X ",(int) self);
   for(i=0;i<lengthOfGenoma;i++)
   {

      if((i>3) && ((i%4)==0)) printf(".");
      printf("%c",genoma[i]);

   }
   printf(" %f\n",fitness);

TRACE3(printf("%8X Interface - exit print %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------
@end
