// Trace.h
//--------------------------------------------------------------------
// Macro TRACE is used to allow easy monitoring of the program's
// behaviour. Each instruction added to print something other to
// compute control-values can be included in the macro body
// TRACE(<statement>).
// Coding the #define TRACE(A) A  the argument of trace will be
// executed
// Coding the #define TRACE(A) // the whole statement will be
// handled as a comment. This way it's allowed leaving statements
// for debug without warrying for the program's performances or
// the outputs.
// Using severale TRACEx macroes, where x may be a number or a letter,
// it's possible to handle more type of tracing.
// For this project we've following traces:
//
// TRACE0 for main
// TRACE1 for observerSwarm
// TRACE2 for modelsSwarm
// TRACE3 for interface
// TRACE4 for ruleMaker
// TRACE5 for shuffler
// TRACE6 for monitoring operations
// TRACE7 for embryo
//
#define TRACE0(A) //
#define TRACE1(A) //
#define TRACE2(A) //
#define TRACE3(A) //
#define TRACE4(A) //
#define TRACE5(A) //
#define TRACE6(A) //
#define TRACE7(A) //

