// 04-Jan-00: adapted from:
// Template application. Copyright  1996-1999 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#include <stdio.h>
#include <string.h>
#import "AquariumObserverSwarm.h"
#import "Fish.h"
#import "Shark.h"
#import <collections.h>
#import <objectbase.h>
#import <gui.h>
#import "../../MNGVideo.h"

@implementation AquariumObserverSwarm

//-----------------------------------------------------------------------
+ createBegin: aZone
{
	AquariumObserverSwarm * obj;
	id <ProbeMap> probeMap;
  
	obj = [super createBegin: aZone];
	obj->displayFrequency = 1;

	probeMap = [EmptyProbeMap createBegin: aZone];
	[probeMap setProbedClass: [self class]];
	probeMap = [probeMap createEnd];

	[probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];

	[probeLibrary setProbeMap: probeMap For: [self class]];

	return obj;
}

- createEnd
{
	return [super createEnd];
}

//--------------------------------------------------------------------
- _worldRasterDeath_ : caller
{
  [worldRaster drop];
  worldRaster = nil;
  return self;
}

- _populationGraphDeath_ : caller
{
  [populationGraph drop];
  populationGraph = nil;
  return self;
}

- buildObjects
{
	[super buildObjects];
  
	// create the probe display for the observer swarm (self)
	CREATE_PROBE_DISPLAY (self);

	observedAquarium = [AquariumSwarm createBegin: [self getZone]];
	observedAquarium = [observedAquarium createEnd];
	CREATE_PROBE_DISPLAY (observedAquarium);
	
	[controlPanel setStateStopped];
	if ([controlPanel getState] == ControlStateQuit)
		return nil;

	[observedAquarium buildObjects];

	colormap = [Colormap create: [self getZone]];
	[colormap setColor: 0 ToName: "grey"];  // background (water)
	[colormap setColor: 1 ToName: "green"]; // fish
	[colormap setColor: 2 ToName: "blue"];   // shark
	
	[[observedAquarium getFishSet] forEach: M(setColor:) : (void*) 1];
	[[observedAquarium getSharkSet] forEach: M(setColor:) : (void*) 2];

	video = [MNGVideo create: self ColorMap: colormap MagFactor: 5];
	
	// the following is stolen from heatbugs
	worldRaster = [ZoomRaster create: [self getZone]];
	[worldRaster enableDestroyNotification: self
		notificationMethod: @selector (_worldRasterDeath_:)];
	[worldRaster setColormap: colormap];
	[worldRaster setZoomFactor: 5];
	[worldRaster setWidth: [[observedAquarium getWorld] getSizeX]
		Height: [[observedAquarium getWorld] getSizeY]];
	[worldRaster setWindowTitle: "Aquarium"];
	[worldRaster pack];				  // draw the window.
	[worldRaster drawSelf];

	agentDisplay = 
    	[Object2dDisplay create: self
			setDisplayWidget: worldRaster
			setDiscrete2dToDisplay: [observedAquarium getWorld]
			setDisplayMessage: M(drawSelfOn:)];
    
	[agentDisplay setObjectCollection: [observedAquarium getAgents]];
 
	[video setObjectLayerGrid: [observedAquarium getWorld]
	  ObjectCollection: nil
	  Message: M(drawSelfOn:)];

	populationGraph = 
		[EZGraph create: self
			setTitle: "Population count of all species"
			setAxisLabelsX: "time" Y: "number"
			setWindowGeometryRecordName: "populationGraph"];
  
	[populationGraph enableDestroyNotification: self
		notificationMethod: @selector (_populationGraphDeath_:)];

	[populationGraph createSequence: "sharks"
		withFeedFrom: [observedAquarium getSharkSet]
		andSelector: M(getCount)];

	[populationGraph createSequence: "fish"
		withFeedFrom: [observedAquarium getFishSet]
		andSelector: M(getCount)];

		return self;
}

//#define DEBUG

- (void) debug
{
#ifdef DEBUG
	timeval_t currentSimTime = getCurrentTime();//[[displayActions getActivity] getCurrentTime];

printf ("simtime=%ld\n", currentSimTime);
	if (currentSimTime<100)
	{
		char fname[8];
		FILE *fp;
		id debugFileStream;

		sprintf (fname, "debug%02d", (int)currentSimTime);
		fname[sizeof(fname)-1] = 0;
		fp = fopen (fname, "w");
		debugFileStream = 
			[OutputStream create: self setFileStream: fp];
		[globalZone describeForEach: debugFileStream];
		[scratchZone describeForEach: debugFileStream];
		fprintf(fp, "Fish = %d, Sharks = %d\n", 
			[[observedAquarium getFishSet] getCount], 
			[[observedAquarium getSharkSet] getCount]);
		fclose (fp);
		[debugFileStream drop];
	}
#endif
}

- buildActions
{
	[super buildActions];
  
	[observedAquarium buildActions];

	displayActions = [ActionGroup create: self];
	[displayActions createActionTo: worldRaster  message: M(erase)];
	[displayActions createActionTo: agentDisplay  message: M(display)];
	[displayActions createActionTo: worldRaster  message: M(drawSelf)];
	[displayActions createActionTo: video  message: M(takeAFrame)];
	[displayActions createActionTo: populationGraph  message: M(step)];
	[displayActions createActionTo: self         message: M(debug)];
	[displayActions createActionTo: probeDisplayManager message: M(update)];
	[displayActions createActionTo: actionCache  message: M(doTkEvents)];

	displaySchedule = [Schedule createBegin: self];
	[displaySchedule setRepeatInterval: displayFrequency];
	displaySchedule = [displaySchedule createEnd];
	[displaySchedule at: 0 createAction: displayActions];
  
	return self;
}  

- activateIn: swarmContext
{
	[super activateIn: swarmContext];

	[observedAquarium activateIn: self];
	[displaySchedule activateIn: self];
  
	return [self getSwarmActivity];
}



@end
