#import "SetSet.h"

//-----------------------------------------------------------------
@implementation SetSet

+ createBegin: aZone
{
	SetSet *obj = [super createBegin: aZone];
	obj->sets = [Set create: aZone];
	return obj;
}

- (void) addSet: aSet
{
	[sets add: aSet];
}

- createEnd
{
	return [super createEnd];
}

//-----------------------------------------------------------------
- (unsigned) getCount
{
	int count=0;
	id index, member;

	index = [sets begin: scratchZone];
	for (member = [index next]; [index getLoc] == Member; member = [index next])
		if (member)
			count += [member getCount];
	[index drop];
	return count;
}

- (void)forEach: (SEL)aSelector
{
  id <Index> index;
  id <Set> member;

  index = [sets begin: scratchZone];
  for (member = [index next]; [index getLoc] == Member; member = [index next])
    if (member)
      [member forEach: aSelector];
  [index drop];
}

- (void)forEach: (SEL)aSelector : arg1
{
  id <Index> index;
  id <Set> member;
  
  index = [sets begin: scratchZone];
  for (member = [index next]; [index getLoc] == Member; member = [index next])
    if (member)
      [member forEach: aSelector : arg1];
  [index drop];
}

- (void)forEach: (SEL)aSelector : arg1 : arg2
{
  id <Index> index;
  id <Set> member;
  
  index = [sets begin: scratchZone];
  for (member = [index next]; [index getLoc] == Member; member = [index next])
    if (member)
      [member forEach: aSelector : arg1 : arg2];
  [index drop];
}

- (void)forEach: (SEL)aSelector : arg1 : arg2 : arg3
{
  id <Index> index;
  id <Set> member;

  index = [sets begin: scratchZone];
  for (member = [index next]; [index getLoc] == Member; member = [index next])
    if (member)
      [member forEach: aSelector : arg1 : arg2 : arg3];
  [index drop];
}
