// File: MultiDiscrete2d.h
// 07-97

// The "MultiDiscrete2d" is a subclass of "Discrete2d" which permits multiple
//   anObjects or values per cell.  This is accomplished by creating a "List"
//   at each cell that contains one or more anObjects or values.

#import <space/Discrete2d.h>

@interface MultiDiscrete2d: Discrete2d
{
}

// Override "putObject/Value:atX:Y:" to accept multiple anObjects/values.
-putObject: anObject atX: (int) x Y: (int) y;
-putValue: (long) v atX: (int) x Y: (int) y;

// New methods to handle removing elements from "Lists".
-removeObject: anObject fromX: (int) x Y: (int) y;
-removeValue: (long) v fromX: (int) x Y: (int) y;

@end
