// File: MultiDiscrete2d.m
// 07-97

#import "MultiDiscrete2d.h"

@implementation MultiDiscrete2d

-putObject: anObject atX: (int) x Y: (int) y
{
  id tempObj;
  id tempList;
  tempList  = [List create: [self getZone]];
  if ((tempObj = *discrete2dSiteAt(lattice, offsets, x, y)) != nil)
  // Cell occupied.
  {
    if ([tempObj getClass] == [tempList getClass])
    // Cell occupied by many anObjects wrapped in a "List".
    // tempObj isa "List".
    // addLast anObject to tempObj.
      [tempObj addLast: anObject];
    else
    // Cell occupied by a single anObject.
    // tempObj isa anObject.
    // Create tempList to contain tempObj and anObject.
    // Link MultiDiscrete2d to tempList.
    {
      [tempList addLast: tempObj];
      [tempList addLast: anObject];
      *discrete2dSiteAt(lattice, offsets, x, y) = tempList;
    }
  }
  else
  // Cell unoccupied.
  // tempObj == nil.
  // Link MultiDiscrete2d to anObject.
    *discrete2dSiteAt(lattice, offsets, x, y) = anObject;
  return self;
}

-putValue: (long) v atX: (int) x Y: (int) y
{
  id tempVal;
  id tempList;
  tempList  = [List create: [self getZone]];
  if ((tempVal = *discrete2dSiteAt(lattice, offsets, x, y)) != nil)
  // Cell occupied.
  {
    if ([tempVal getClass] == [tempList getClass])
    // Cell occupied by many values wrapped in a "List".
    // tempVal isa "List".
    // addLast (id) v to tempVal.
      [tempVal addLast: (id) v];
    else
    // Cell occupied by a single value.
    // tempVal isa value.
    // Create tempList to contain tempVal and (id) v.
    // Link MultiDiscrete2d to tempList.
    {
      [tempList addLast: tempVal];
      [tempList addLast: (id) v];
      *discrete2dSiteAt(lattice, offsets, x, y) = tempList;
    }
  }
  else
  // Cell unoccupied.
  // tempVal == nil.
  // Link MultiDiscrete2d to (id) v.
    *discrete2dSiteAt(lattice, offsets, x, y) = (id) v;
  return self;
}

-removeObject: anObject fromX: (int) x Y: (int) y
{
  id tempObj;
  id tempList;
  tempList  = [List create: [self getZone]];
  if ((tempObj = *discrete2dSiteAt(lattice, offsets, x, y)) != nil)
  // Cell contains anObject(s) (as expected).
    if ([tempObj getClass] == [tempList getClass])
    // Cell occupied by many anObjects wrapped in a "List".
    // tempObj isa "List".
    {
      if ([tempObj contains: anObject])
      {
	[tempObj remove: anObject];
	if ([tempObj getCount] == 1)
	// tempObj only contains one anObject.
	// "Unwrap" the anObject.
	  *discrete2dSiteAt(lattice, offsets, x, y) = [tempObj getFirst];
      }
      else
	[Warning setMessageString: "MD2D: Can only remove anObject from cell which contains it.\n"];
    }
    else
    // Cell contains a single anObject.
    // tempObj isa anObject.
    {
      if (tempObj == anObject)
	*discrete2dSiteAt(lattice, offsets, x, y) = nil;
      else
	[Warning setMessageString: "MD2D: Can only remove anObject from cell which contains it.\n"];
    }
  else
  // Cell stores no values (error).
    [Warning setMessageString: "MD2D: Cannot remove anObject from unoccupied cell.\n"];
  return self; 
}

-removeValue: (long) v fromX: (int) x Y: (int) y
{
  id tempVal;
  id tempList;
  tempList  = [List create: [self getZone]];
  if ((tempVal = *discrete2dSiteAt(lattice, offsets, x, y)) != nil)
  // Cell stores values (as expected).
    if ([tempVal getClass] == [tempList getClass])
    // Cell stores many values wrapped in a "List".
    // tempVal isa "List".
    {
      if ([tempVal contains: (id) v])
      {
	[tempVal remove: (id) v];
	if ([tempVal getCount] == 1)
	// tempVal only contains one (long) v.
	// "Unwrap" the (long) v.
	  *discrete2dSiteAt(lattice, offsets, x, y) = [tempVal getFirst];
      }
      else
	[Warning setMessageString: "MD2D: Can only remove value from cell which contains it.\n"];
    }
    else
    // Cell stores a single value.
    // tempVal isa (long) v.
    {
      if (tempVal == (id) v)
	*discrete2dSiteAt(lattice, offsets, x, y) = 0;
      else
	[Warning setMessageString: "MD2D: Can only remove value from cell which contains it.\n"];
    }
  else
  // Cell stores no values (error).
    [Warning setMessageString: "MD2D: Cannot remove value from unoccupied cell.\n"];
  return self; 
}

@end
