// File: MultiObject2dDisplay.h
// 07-97

// "MultiObject2dDisplay" is a subclass of "Object2dDisplay" that can display a
//   "MultiDiscrete2d".  A "MultiObject2dDisplay" loops through a "(Multi)Discrete2d"
//    displaying every occupied cell based on the number of elements at that cell.
//    For the sake of compatibility, "MultiObject2dDisplay" retains all of the
//    capabilities of its superclass.

#import <space/Object2dDisplay.h>
#import "MultiDiscrete2d.h"

@interface MultiObject2dDisplay: Object2dDisplay
{
  BOOL isMulti; // Flag variable denoting whether the "Multi-" option is engaged.
}

// Override "setDiscrete2dToDisplay" so that it checks the class of its argument "c".
//   If c isa MultiDiscrete2d, it sets the flag variable "isMulti" to YES; otherwise,
//   it sets "isMulti" to NO.  "isMulti" is then used by the overridden "createEnd"
//   to determine final initialization procedure.
-setDiscrete2dToDisplay: (Discrete2d *) c;
-createEnd;

// Create a second display fxn "display::" to display each occupied cell based
//   on the number of elements at that cell.  The "min/maxC" arguments determine
//   the range of colors to use.  The regular "display" fxn is still supported.
-display: (int) minC : (int) maxC;

@end
