#import <gui.h>
#import "SimObject.h"

#import "globals.h"

@interface Boid: SimObject
{
  id <Vector>acceleration; // [m/(sec^2)] acceleration requested at last update.
  id <Vector>flockCenter;  // the center of the flock I see

  id <Vector> calc;        // used each time step in visible

  double maxVelocity;       // [m/sec]
  double maxAcceleration;   // [m/(sec^2)]
  double cruiseDistance;    // [m] Default value is twice the bodylength.


  id closestBoid[NUMOBJECTTYPES];

}

+ (Boid *) createBegin: aZone;
- createEnd;
- init: (int) id : (int) type
      : (id <Vector>) p
      : (id <Vector>) v
      : (double  ) r; 



- step;

- (double) accumulate: (id <Vector>)valueToAdd;
- (double) getProbeLength;
// Returns how far in front of boid to probe for obstacles.
- updateVisibilityList;
  
- (id <Vector>)wander;
  // Returns a vector which indicates how the boid would like to accelerate
  // when not under any other influences. Related to desiredCruisingSpeed().

- (id <Vector>)collisionAvoidance;
  // Returns a vector which indicates how the boid would like to accelerate
  // in order to avoid collisions with non-boid obstacles.

- (id <Vector>)maintainingCruisingDistance;
  // Returns a vector which indicates how the boid would like to accelerate
  // in order to maintain a distance of cruiseDistance from the nearest
  // visible boid. 

- (id <Vector>)velocityMatching;
  // Returns a vector which indicates how the boid would like to accelerate
  // in order to fly at approximately the same speed and direction as the
  // nearby boids.

- (id <Vector>)flockCentering;
  // Returns a vector which indicates how the boid would like to accelerate
  // in order to be near the center of the flock.

- (id <Vector>)predatorAvoidance;
// PREY avoids PREDATORs

- (id <Vector>)navigator;
// This method prioritizes and resolves the acceleration vectors
// It returns the actual acceleration vector that the boid will apply
// to its flight in the current time step.
  


- printSelf;
@end
