#import "ModelSwarm.h"
#import "Boid.h"
#import "Vector.h"
#import <random.h>
#import <objectbase.h>

// Implementation of the model for ppl.

@implementation ModelSwarm

+ create: aZone {

  id <ProbeMap> probeMap;
  ModelSwarm *obj;

  obj = [super create: aZone];

  obj->numAgents = 10;
  obj->agentID   = 0;
  obj->worldXSize = 500;
  obj->worldYSize = 500;

  obj->boidRaster = nil;

  obj->useBoidCanvas = "No";
  obj->useBoidRaster = "Yes";

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "numAgents"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldXSize"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldYSize"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "useBoidCanvas"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "useBoidRaster"
                                    inClass: [self class]]];

  //  probeMap = [CustomProbeMap create: aZone
  //			     forClass: [self class]
  //			     withIdentifiers: "numAgents",
  //			     "worldXSize",
  //			     "worldYSize", NULL];

  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  return obj;

}



///////////////////////////////////////////////////////
//
// buildObjects
//
///////////////////////////////////////////////////////
- buildObjects {

  int i, type;
  double x, y;
  double vx, vy;
  double radius=0;
  Vector *position   = [Vector create: self];
  Vector *velocity   = [Vector create: self];
  Boid *agent;

  
  //  printf ("ModelSwarm\tbuildObjects\n");

  [super buildObjects];

  // build the list to keep track of the agents
  objectList  = [List create: self];


  if(boidRaster != nil) {

     [self buildBoidSpace];
 
  }






  // build the agents
  for (i = 0; i < numAgents; i++) {
    
      x = [uniformDblRand getDoubleWithMin: 0.0 withMax: (double) worldXSize];
      y = [uniformDblRand getDoubleWithMin: 0.0 withMax: (double) worldYSize];

      vx = [uniformDblRand getDoubleWithMin: -5.0 withMax: 5.0];
      vy = [uniformDblRand getDoubleWithMin: -5.0 withMax: 5.0];

      //type = [uniformIntRand getIntegerWithMin: 0 withMax: NUMBOIDTYPES-1];
      type = [uniformIntRand getIntegerWithMin: 0 withMax: 0];

      if (type == PREDATOR) {

          type = [uniformIntRand getIntegerWithMin: 0 withMax: NUMBOIDTYPES-1];

      }

      if(0) {

           fprintf(stderr, "MODELSWARM >>>> buildObjects type = %d\n", (int) type);
           fflush(0);

      }


      agent = [Boid createBegin: self];

      [agent initModel: self];

      radius = (type == PREY) ? 10.0 : 20.0;

      [agent init: ++agentID : type
                             : [position init: x : y]
                             : [velocity init: vx : vy]
                             : radius];





      if(canvas) [agent createDisplay];
      [agent createEnd];
      [objectList addLast: agent];

  }  // for numAgents


  //
  // Now create some obstacles
  //
  if(1) {

      [velocity init]; // reset to {0.0, 0.0}

      agent = [SimObject createBegin: self];
      [agent init: ++agentID : OBSTACLE
	     : [position init: worldXSize/4 : worldYSize/2.0] : velocity : 20.0];
      [agent initModel: self];
      if(canvas) [agent createDisplay];
      [agent createEnd];
      [objectList addLast: agent];
  
      agent = [SimObject createBegin: self];
      [agent init: ++agentID : OBSTACLE
	     : [position init: worldXSize/2 : worldYSize/4.0] : velocity : 20.0];
      [agent initModel: self];
      if(canvas) [agent createDisplay];
      [agent createEnd];
      [objectList addLast: agent];
  
      agent = [SimObject createBegin: self];
      [agent init: ++agentID : OBSTACLE
	     : [position init: worldXSize/2 : worldYSize/2.0] : velocity : 20.0];
      [agent initModel: self];
      if(canvas) [agent createDisplay];
      [agent createEnd];
      [objectList addLast: agent];

  }
  
  [position   drop];
  [velocity   drop];

  // printf("ModelSwarm:\tbuildObjects:\tDone.\n");
  return self;

}


//////////////////////////////////////////////////////
//
// buildBoidSpace
//
//////////////////////////////////////////////////////
- buildBoidSpace {

  //
  // Build the discrete2d space
  //
  boidSpace = [BoidSpace createBegin: self];

  [boidSpace setSizeX: worldXSize Y: worldYSize];

  [boidSpace setRaster: boidRaster];
  [boidSpace setBoids: objectList];

  boidSpace = [boidSpace createEnd];

  return self;

}


//////////////////////////////////////////////////////////
//
// buildActions
//
/////////////////////////////////////////////////////////
- buildActions {

  [super buildActions];

  //  printf("ModelSwarm:\tbuildActions:\tbegin.\n");

  modelSchedule = [Schedule createBegin: self];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];

  [modelSchedule at: 0 createActionForEach: objectList message: M(step)];
  //[modelSchedule at: 0 createActionTo: self message: M(dropDead)];


  return self;

}

- activateIn: swarmContext {

  // send a message to our super activating ourselves in their schedule
  [super activateIn: swarmContext];

  // then send a message to our schedule to start our actions
  [modelSchedule activateIn: self];

  // pass back the SwarmActitivity in the queue
  return [self getSwarmActivity];

}




//////////////////////////////////////////////////////////
//
////      SET
//////
////////
/////////////////////////////////////////////////////////
- setRaster: (id <Raster>) aRaster {

  boidRaster = aRaster;

  return self;

}
    



///////////////////////////////////////////
//
// setCanvas
//
///////////////////////////////////////////
- setCanvas: (id <Canvas>) c
{
  canvas = c;
  return self;
}



/////////////////////////////////////////////
//
// getCanvas
//
/////////////////////////////////////////////
- (id <Canvas>) getCanvas
{
  return canvas;
}





/////////////////////////////////////////
//
// display
//
////////////////////////////////////////
- display
{
  [objectList forEach: @selector(display)];
  return self;
}




/////////////////////////////////////////////////
//
// getObjectList
//
////////////////////////////////////////////////
- (id <List>) getObjectList { 
 
        return objectList;

}



/////////////////////////////////////////////////////
//
// getWorldSize 
//
///////////////////////////////////////////////////
- (int) getWorldXSize { return worldXSize;}
- (int) getWorldYSize { return worldYSize;}



///////////////////////////////////////////////////
//
// getBoidSpace
//
//////////////////////////////////////////////////
- getBoidSpace {

   return boidSpace;

}


//////////////////////////////////////////////////
//
// getBoids
//
//////////////////////////////////////////////////
- getBoids {

   return objectList;

}



////////////////////////////////////////////////
//
// useBoidRaster
//
////////////////////////////////////////////////
- (char *) useBoidRaster {

   return useBoidRaster;

}

////////////////////////////////////////////////
//
// useBoidCanvas
//
////////////////////////////////////////////////
- (char *) useBoidCanvas {

   return useBoidCanvas;

}
@end

