// Copyright (C) 1999 University of Washington, Columbia Basin Research. 
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.


// SearchableTreeNode will make up a space partitioning tree to efficiently
//  answer the questions "where is the allocated object closest to (x,y)?",
//  and "list all of the allocated objects within this bounding box."
// NOTE: a treenode owns a bounding box of x & y indices, from minX to maxX
//  inclusive and from minY to maxY inclusive. If the node is a leaf node
//  then "objId" is the contents, and all child pointers are NULL. Otherwise,
//  "objId" is nil and the box is partitioned equally (the center point 
//  belongs to the southeast quadrant) and up to four subnodes are created.

#import <objectbase/SwarmObject.h>
#import "SearchableObject.h"

// northeast corner: x+, y-; northwest corner: x-, y-; etc.
#define NE 0
#define NW 1
#define SE 2
#define SW 3
#define FIRSTCHILD 0
#define LASTCHILD 3

@interface SearchableTreeNode: SwarmObject {
  id child[4];        // pointers to child treenodes, or nil
  id parent;          // pointer to parent treenode, or nil for root of tree.
  id objId;           // if a leaf node, the contents. Otherwise, nil.
  double minX, minY;  // northwest point of bounding box covered.
  double maxX, maxY;  // southeast point of bounding box covered.
  double centX, centY;// center point which divides subtrees, OR,
                      //  location of object(s) in this bounding box.
  int searchState;    // Used for iterated enumeration of tree.
}

// Simple accessor methods are all that we need for this object.
- setChildAt: (int) corner Id: aChild;
- getChildAt: (int) corner;

- setParent: aParent;
- getParent;

- setBoxMinX: (double) minx maxX: (double) maxx
        minY: (double) miny maxY: (double) maxy;
- setObject: anId;
- setCenterX: (double) centerX Y: (double) centerY Obj: anId;
- getObject;

- (double) getMinX;
- (double) getMaxX;
- (double) getMinY;
- (double) getMaxY;
- (double) getCentX;
- (double) getCentY;

- setSearchState: (int) aState;
- (int)getSearchState;
@end
