// Copyright (C) 1999 University of Washington,Columbia Basin Research.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "SearchableTreeNode.h"

@implementation SearchableTreeNode

// Simple accessor methods are all that we need for this object.
- setChildAt: (int) corner Id: aChild {
  child[corner] = aChild;
  [aChild setParent: self];
  return self;
}

- getChildAt: (int) corner {
  return child[corner]; 
}

- setParent: aParent {
  parent = aParent;
  return self;
}

- getParent {
  return parent;
}

- setBoxMinX: (double) minx maxX: (double) maxx
        minY: (double) miny maxY: (double) maxy {
  minX = minx;
  maxX = maxx;
  minY = miny;
  maxY = maxy;
  return self;
}

- setObject: anId {
  objId = anId;
  return self;
}

- setCenterX: (double) centerX Y: (double) centerY Obj: anId {
  centX = centerX;
  centY = centerY;
  objId = anId;
  return self;
}

- getObject {
  return objId;
}

- (double) getMinX {
  return minX;
}

- (double) getMaxX {
  return maxX;
}

- (double) getMinY {
  return minY;
}

- (double) getMaxY {
  return maxY;
}

- (double) getCentX {
  return centX;
}

- (double) getCentY {
  return centY;
}

- setSearchState: (int) aState {
  searchState = aState;
  return self;
}

- (int)getSearchState {
  return searchState;
}

@end
