// Out-Migrant Survival Simulator. Copyright (C) 1999 University of Washington,
// Columbia Basin Research. Developed by Lang, Railsback & Assoc., Arcata CA.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.


// "TreeNode"s will make up a binary space partitioning tree to efficiently
//  answer the question "where is the allocated object closest to (x,y)?".
// NOTE: a treenode owns a bounding box of x & y indices, from minX to maxX
//  inclusive and from minY to maxY inclusive. If there is exactly one
//  allocated object within that box, "pointId" is it, and all child pointers
//  are NULL. Otherwise, the box is partitioned equally (the center point
//  belongs to the southeast quadrant) and up to four subnodes are created.

#import <objectbase/SwarmObject.h>

#import "globals.h"

@interface TreeNode: SwarmObject {
  id children[4];        // pointers to child treenodes, or nil
  int minX, minY;        // northwest point of bounding box covered.
  int maxX, maxY;        // southeast point of bounding box covered.
  int centX, centY;      // center point which divides subtrees, OR, location
                         // of single point in this bounding box.
  id pointId;            // if only one allocated object is in this bounding
                         //  box, here it is.
}

// Simple accessor methods are all that we need for this object.
- setChildAt: (int) corner Id: child;

- getChildAt: (int) corner;

- setBoxMinX: (int) mnX maxX: (int) mxX minY: (int) mnY maxY: (int) mxY;
- setCenterX: (int) cntX Y: (int) cntY Obj: anId;

- (int) getMinX;
- (int) getMaxX;
- (int) getMinY;
- (int) getMaxY;
- (int) getCentX;
- (int) getCentY;
- getObject;

@end
