//  2d Feeding Optimization
//  Copyright 8/18/00 Andrew Lovett, under the supervision of Louis Gross
//  Check the file Info/CopyrightInfo.txt for copyright information

//This is the parent class for all animal-like agents used in this program

import swarm.Globals;
import swarm.objectbase.Swarm;
import swarm.objectbase.SwarmImpl;
import swarm.defobj.Zone;
import swarm.activity.Activity;
import swarm.activity.Schedule;
import swarm.Selector;
import swarm.space.Grid2d;
import swarm.gui.Raster;

import java.util.LinkedList;
import java.util.List;

import java.io.FileReader;
import java.io.BufferedReader;

public abstract class Animal extends SwarmImpl {
	int speed; //a speed of 1 means the animal moves every timestep
	int sight; //the distance an animal looks to find food
	int size;  //currently, this only relates to the size of the rectangle drawn
	int x, y; //the animal's location on the grid
	int age; //easy one, this starts at zero and increases
	boolean alive; //starts at true, remains there until...well...guess
	boolean hasHadBabies; //equals false until the animal gives birth
	
	protected Space2d world; //the 2-d world in which the animal lives
	public static SimulationState state; //we have to update this from time to time
	private Landscape papaswarm; //it's too bad that this class has any 
					//knowledge of its papaswarm,
					//but it's necessary for birthing and killing animals
	byte color;

	//more complicated animal-type-specific info
	int energy, maxEn; //if an animal runs out of energy, it dies
	int babyAge, oldAge; //age to have a baby and age at which it dies
					//once babyAge is reached, maxEn doubles
	int numBabies; //the number of babies the animal will have
	int enToMove, enFromFood, enForBaby; //energy required to move, 
							//energy regained from food,
							//energy lost in childbirth

	public final static double DEATH_CHANCE = .1; //chance per timestep of dying
 	public final static double BIRTH_CHANCE = .35; //of old age or of giving birth


	//this member class is used to send information about movement between 	//functions
	protected class Point {
		int x;
		int y;
		

		protected Point (int x, int y) {
			this.x = x;
			this.y = y;
		}
	}

	//the constructor
	public Animal (Zone thZone, Landscape thWorld, int speed, int sight, int size, 			int x, int y, byte color, int maxEn, int babyAge, int oldAge, 
			int numBabies, int enToMove, int enFromFood, int enForBaby) {

		super (thZone);
		
		//assign all those values to the fields of the Animal class
		alive = true;
		hasHadBabies = false;
		
		this.x = x;
		this.y = y;

		this.speed = speed;
		this.sight = sight;
		this.size = size;
		this.color = color;

		world = thWorld.getWorld ();
		//put the object in space
		world.putObject$atX$Y (this, x, y);
		papaswarm = thWorld;

		//and the other stuff...
		this.maxEn = maxEn;
		this.energy = maxEn / 2; //start with half the maximum energy
		this.babyAge = babyAge;
		this.oldAge = oldAge;
		this.numBabies = numBabies;
		this.enToMove = enToMove;
		this.enFromFood = enFromFood;
		this.enForBaby = enForBaby;
		age = 0;
	}

	//every animal grows older, loses energy that can only be replenished through 	//eating, etc; in this program, they all can give birth, too
	public void grow () {
		age++;
		double holder; //holds random numbers used to determine whether the 						//animal will give birth or die this turn, assuming it 					//is the right age
		energy--;   //only lose one point of energy a turn, normally
		
		//when they become adults, their maximum energy doubles
		if (age == babyAge)
			maxEn = maxEn * 2;

		holder = Globals.env.uniformDblRand.getDoubleWithMin$withMax (0.0, 1.0);

		//if the animal hasn't had babies yet, and its old enough and it has 			//enough energy, it might just have a baby or two
		if (!(hasHadBabies) && 
		((age >= babyAge) && (energy > enForBaby) && (holder < BIRTH_CHANCE))) {
			makeBabies ();
			hasHadBabies = true;
			energy -= enForBaby;
		}

		holder = Globals.env.uniformDblRand.getDoubleWithMin$withMax (0.0, 1.0);

		//the only difference between these deaths is that of whether the number 		//of animals who have starved or the number of animals who have die of 			//old age is updated
		if (energy <= 0) {
			state.Num_Starved++;
			die ();
		}
		else if ((age >= oldAge) && (holder < DEATH_CHANCE)){
			state.Num_OldAged++;
			die ();
		}		

	}
	
	//when an animal dies, it gets removed from the LinkedList allAnimals, it 	//disappears from the grid, it is told that it is dead (alive = false), and 	//various death counters are updated
	private void die () {
		papaswarm.allAnimals.remove (this);
		world.putObject$atX$Y (null, x, y);
		world.dieHere (x, y);

		alive = false;
		state.Death_Count++;

		if (this instanceof Cow)
			state.Total_Cows--;
		else if (this instanceof Koala)
			state.Total_Koalas--;
		else if (this instanceof Horse)
			state.Total_Horses--;
		else if (this instanceof Monkey)
			state.Total_Monkeys--;
		else if (this instanceof Human)
			state.Total_Humans--;

		//reaper.at$createActionTo$message (Globals.env.getCurrentTime () + 1, 
											//this, timeToDie);
		//(getActivity ()).terminate ();
	}

	//this creates babies of the appropriate number and type and places them in 	//squares adjacent to the parent
	//sorry, but if there are no free spaces around you, you ain't having kids
	private void makeBabies () {
		Animal newOne;
		int xmov, ymov;

		//holds all possible birth spots for a bay
		LinkedList babySpaces = new LinkedList (); 

		for (int b = 1; b <= numBabies; b++) {
			xmov = 0; ymov = 0;
			babySpaces.clear ();

			//this locator puts all possible birth places for a baby into a 				//list, so one can be chosen at random
			for (int i = -1; i <= 1; i++)
				for (int j = -1; j<= 1; j++)
					//looking at empty places on the map
					if ((legalPos (x + i, y + j))
						&&
					(world.getObjectAtX$Y (x + i, y + j) == null)) 								{
							babySpaces.add (new Point (i, j));
						}

			if (!babySpaces.isEmpty ()) {
				//randomly pick an adjacent space from those available for a 				//baby to move to
				Point babyChoice = (Point) (babySpaces.get 								(Globals.env.uniformIntRand.getIntegerWithMin$withMax  									(0, babySpaces.size () - 1)));
				xmov = babyChoice.x;
				ymov = babyChoice.y;
				
				if (this instanceof Cow) {	
					newOne = new Cow (papaswarm.getZone (), papaswarm, 
									x + xmov, y + ymov);
					state.Total_Cows++;
				}
				else if (this instanceof Koala) {	
					newOne = new Koala (papaswarm.getZone (), papaswarm, 
									x + xmov, y + ymov);
					state.Total_Koalas++;
				}
				else if (this instanceof Horse) {
					newOne = new Horse (papaswarm.getZone (), papaswarm,
									x + xmov, y + ymov);
					state.Total_Horses++;
				}
				else if (this instanceof Monkey) {
					newOne = new Monkey (papaswarm.getZone (), papaswarm,
									x + xmov, y + ymov);
					state.Total_Monkeys++;
				}
				else if (this instanceof Human) {
					newOne = new Human (papaswarm.getZone (), papaswarm,
									x + xmov, y + ymov);
					state.Total_Humans++;
				}
				else
					newOne = null;
				state.Birth_Count++;
				papaswarm.addBaby (newOne, x + xmov, y + ymov);
			}
		}
	}

	//this is simple, the food in your square goes down by one and your energy goes 	//up the appropriate amount, but never higher than max energy
	public void eatFood () {
		if (world.getFood (x, y) > 0) {
			world.addFood (x, y, -1);
			energy += enFromFood;
			if (energy > maxEn)
				energy = maxEn;
		}
	}	
		
	//returns an animal's distance from the nearest food other than the food at the 	//animal's present location; does not count spaces that are occupied; 	//currently, this is only used by Human
	//farest, which should be less than an animal's sight, is the greatest distance 	//away which an animal will check
	protected int getNearestFood (int farest) {
		int dist; //distance to a given point
		int nearestFood = sight + 1;

		for (int i = - farest; i <= farest; i++)
			for (int j = - farest; j <= farest; j++)
				if ((legalPos (x + i, y + j))
				&& (world.getFood (x + i, y + j) > 0) 
				&& !((i == 0) && (j == 0)) 
				&& (world.getObjectAtX$Y (x + i, y + j) == null)) {
					dist = (Math.abs (i) > Math.abs (j)) ? 
								Math.abs (i) : Math.abs (j);
					if (dist < nearestFood)
						nearestFood = dist;
				}
	
		return nearestFood;
	}
					
//NOTE: Although I am keeping the following function around for reference purposes, I //am no longer using it because the new bestFood () function is much faster.
	//finds the direction of the best food space within sight of the animal 
	//closer food is always better than farther off food
	/*private Point bestFood () {
		int numIdeal = 0; //the number of ideal spots
		int idealFood = 0; //the amount of food located at the ideal spot
		int foodHere; //food at any given spot
		int x2, y2; //coordinates for the location to which an animal must move
				//immediately if it wants to reach the ideal food destination
		int turns; //the number of turns it would take to move to a given space
		int leastturns = sight; //the number of turns away from the closest food
	
		LinkedList spaces = new LinkedList (); //a list of the best moves

						
		for (int i = - sight; i <= sight; i++)
			for (int j = - sight; j <= sight; j++) {
				x2 = (i == 0) ? 0 : i / Math.abs (i);
				y2 = (j == 0) ? 0 : j / Math.abs (j);
 
				//looking for spaces that are empty
				//plus they can't be off the map
				if ((legalPos (x + i, y + j)) 
					&&
				(world.getObjectAtX$Y (x + x2, y + y2) == null)) {
					foodHere = world.getFood (x + i, y + j);

					turns = (Math.abs (i) > Math.abs (j)) ? 
						Math.abs (i) : Math.abs (j);

					if ((foodHere > 0) && (turns < leastturns)) {
						idealFood = foodHere;
						leastturns = turns;
						numIdeal = 1;
						spaces.clear ();
						spaces.add (new Point (x2, y2));
					}
					else if ((foodHere > idealFood) && (turns == 							leastturns)) {
						idealFood = foodHere;
						numIdeal = 1;
						spaces.clear ();
						spaces.add (new Point (x2, y2));
					}
					else if ((foodHere == idealFood) && (turns == 							leastturns)) {
						numIdeal++;
						spaces.add (new Point (x2, y2));
					}
				}
			}

		if (numIdeal == 1) 
			return ((Point) spaces.getFirst ());
		else if (numIdeal == 0)
			return (new Point (0, 0));
		else //if there are several ideal moves, we randomly pick one of them
			return ((Point) spaces.get (randGen.nextInt (numIdeal)));
	}*/

	//finds the direction of the best food space within sight of the animal 
	//begins by checking the square immediately around the animal and then expands 	//the square and checks all points a distance of 1 away from the animal, and 	//then expands the square again, continuing this till the distance between the 	//animal and the edge of the square is the animal's sight; never looks beyond 	//the first square in which any food is found
	private Point bestFood () {
		int numIdeal = 0; //the number of ideal spots
		int idealFood = 0; //the amount of food located at the ideal spot
		int foodHere; //food at any given spot
		int x2, y2; //coordinates for the location to which an animal must move
				//immediately if it wants to reach the ideal food destination

		int x3, y3; //indicate the direction of and distance to a given point
			//these are the same as the i and j in the for loops except that 				//they have been multiplied by k and l, so they may be negative

		LinkedList spaces = new LinkedList (); //a list of the best moves
		
		for (int i = 1; i <= sight; i++) {
		  spaces.clear ();
		  numIdeal = 0;
		  for (int j = - i; j <= i; j++) {
		  	for (int combo = 1; combo <= 4; combo++) {
				switch (combo) {
					case 1: 
						x3 = j; y3 = i; break;
					case 2:
						x3 = i; y3 = j; break;
					case 3:
						x3 = j; y3 = - i; break;
					case 4:
						x3 = - i; y3 = j; break;
					default:
				}

				//only go through this if we haven't already done this one
				if (!(((j == i) && (combo == 2)) 
				|| ((j == -i) && (combo == 4)))) {					

					x2 = (x3 == 0) ? 0 : x3 / Math.abs (x3);
					y2 = (y3 == 0) ? 0 : y3 / Math.abs (y3);

					//this spot can't be off the map
					//plus the nearest space on the way to this spot must 					//be empty
					if ((legalPos (x + x3, y + y3)) 
						&&
					(world.getObjectAtX$Y (x + x2, y + y2) == null)) {
						foodHere = world.getFood (x + x3, y + y3);

						if (foodHere > idealFood) {											idealFood = foodHere;
							numIdeal = 1;
							spaces.clear ();
							spaces.add (new Point (x2, y2));
						}
						else if (foodHere == idealFood) {
							numIdeal++;
							spaces.add (new Point (x2, y2));
						}
					}
				} //end if !(j == i) etc

			} //for int method

	     	  } //for int j
		  if (idealFood > 0)
			break;

		} //for int i

		if (numIdeal == 1) 
			return ((Point) spaces.getFirst ());
		else if (numIdeal == 0)
			return (new Point (0, 0));
		else //if there are several ideal moves, we randomly pick one of them
			return ((Point) spaces.get 	
				(Globals.env.uniformIntRand.getIntegerWithMin$withMax 
										(0, numIdeal - 1)));
	}


	//find the space with the best food, and expend the energy to move toward it
	public void moveToBestFood () {
		int newx, newy;
		Point newLoc;

		//under the current setup, an animal will move if its remaining energy is 		//equal to the energy required to move; this means that, if the two are 		//equal, the animal will die after moving unless it moves on to a space 		//that contains food
		if (energy >= enToMove) {
			//try to save time by checking foodInSight, but only if the total 			//food is under 230, otherwise there's so much food that there's 				//almost sure to be some in sight
			if ((state.Total_Food < 230) && !foodInSight ()) {
				newx = x + 
				Globals.env.uniformIntRand.getIntegerWithMin$withMax (-1, 1);

				newy = y + 
				Globals.env.uniformIntRand.getIntegerWithMin$withMax (-1, 1);

				if (!((legalPos (newx, newy)) 
				&& (world.getObjectAtX$Y (newx, newy) == null))) {
					newx = x;
					newy = y;
				}
			}
			else {
				newLoc = bestFood (); //we know for sure that this loc 
										//is on the map

				newx = x + newLoc.x;
				newy = y + newLoc.y;
			}

			world.putObject$atX$Y (null, x, y);
			world.putObject$atX$Y (this, newx, newy);
			
			x = newx;
			y = newy;
			energy -= enToMove;		
		}
	}
	
	//this is a time-saving method that uses info about where an animal is in a 	//region and how much food remains in the regions to quickly determine whether 	//there is any chance of there being food within the animal's line of sight; if 	//this function returns false, there is no food within the animal's sight, but 	//if the function returns true, there may or may not be food, so we much go 	//through the much longer bestFood () method
	private boolean foodInSight () {
		Foodspace myregion; //region in which the animal is located
	
		//if there's no food on the entire grid, there's obviously no food in 													//sight
		if (state.Total_Food <= 0)
			return false;

		//myregion = world.getRegion (world.regXVal2 (x),world.regYVal2 (y));
		
		//if there is no food in any of the regions within the animal's sight, 			//there ain't no food in sight
		if (!world.regionWithFoodWithinRange (x, y, sight))
			return false;

		return true;
	}

	//make sure the x and y coordinates are on the grid
	public boolean legalPos (int x, int y) {
		return ((x >= 0) && (x <= world.getSizeX () - 1) 
			&& 
		(y >= 0) && (y <= world.getSizeY () - 1)); 
	}
	
	//sends activateIn up to the SwarmImpl parent class
	public Activity activateIn (Swarm papaswarm) {
		super.activateIn (papaswarm);
	
		return getActivity ();
	}
	
	//all animals are represented by squares
	public void drawMe (Raster r) {
		//here's part of my not-so-efficent method of getting the food
		//drawn in
		papaswarm.drawFood (r);
		if (alive)
			r.fillRectangleX0$Y0$X1$Y1$Color 
				(x - size, y - size, x + size, y + size, color);
	}
}
