//  2d Feeding Optimization
//  Copyright 8/18/00 Andrew Lovett, under the supervision of Louis Gross
//  Check the file Info/CopyrightInfo.txt for copyright information

//This particular class sets up a 2d space in which food can be created
//The entire 2d space will consist of several of these

import swarm.Globals;

public class Foodspace {
	public static SimulationState state; //we need a reference to this so we can 												//update Total_Food

	private int food ; //keeps track of the total amount of food in the Foodspace	
	private int[][] foodArray; //a Foodspace is a 2d array of food measure in 								//integer values
	private int sizeX, sizeY; //the dimensions of the space (and of the array)
	public int regNum; //this foodspace's region number
	
	//this constructor creates the 2d array, empties it, and then dumps a given 	//amount of food on it
	public Foodspace (int x, int y, int regNum, int food) {
		foodArray = new int[x][y];
		sizeX = x;
		sizeY = y;
		this.regNum = regNum;
		
		emptySpace ();
		dumpFood (food);
	}

	public int getSizeX () {
		return sizeX;
	}

	public int getSizeY () {
		return sizeY;
	}

	public int getTotalFood () {
		return food;
	}

	//returns the amount of food at a given point on the Foodspace
	public int getFood (int x, int y) {
		return foodArray [x][y];
	}

	//we fill the 2d array with 0s when we first create it
	public void emptySpace () {
		food = 0;
		for (int i = 0; i <= sizeX - 1; i++)
			for (int j = 0; j <= sizeY - 1; j++)
				foodArray [i][j] = 0;
	}

	//add some amount of food to a point on the Foodspace
	//if you try to add more food than the max, the rest of it just vanishes
	public void addFood (int x, int y, int amount) {
		if (foodArray [x][y] + amount > Landscape.MAXFOOD)
			amount = Landscape.MAXFOOD - foodArray [x][y];
		
		foodArray [x][y] += amount;
		state.Total_Food += amount;
		Space2d.modFoodDeathForRegion (amount, 0, regNum);
		food += amount;
	}

	//disperses the given amount of food randomly throughout the Foodspace
	public void dumpFood (int amount) {
		for (int i = 1; i <= amount; i++) {
			int xval, yval;
			xval = Globals.env.uniformIntRand.getIntegerWithMin$withMax 
											(0, sizeX - 1);
			yval = Globals.env.uniformIntRand.getIntegerWithMin$withMax 
											(0, sizeY - 1);

			addFood (xval, yval, 1);
		}
	}


}
