//  2d Feeding Optimization
//  Copyright 8/18/00 Andrew Lovett, under the supervision of Louis Gross
//  Check the file Info/CopyrightInfo.txt for copyright information

//Humans, the best creatures to date, have impressive stats (although they give birth //to babies at an especially old age) and a greater ability to determine whether it //is worth their while to go in search of more food

import swarm.Globals;
import swarm.objectbase.Swarm;
import swarm.objectbase.SwarmImpl;
import swarm.defobj.Zone;
import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;
import swarm.activity.Activity;
import swarm.Selector;

public class Human extends Animal {

	Schedule schedule; //we use the schedule object to schedule the actions

	//the three following variables are all found in Animal, Human's parent class, 	//but they have been added to this class so that they will show up whenever the 	//user probes an animal of this type
	int age;
	int energy;
	boolean alive;

	//Human Stats, see the Animal class for info on what each stat means
	//If you wish to modify these stats, go to Data\HumanData.txt
	//As these values will be modified only once, at the beginning of a simulation, 	//we will keep them in all-caps, as though they were constants
	public static int SPEED;
	public static int SIGHT;
	public static int SIZE;
	public static int MAXEN;
	public static int BABYAGE;
	public static int OLDAGE;
	public static int NUMBABIES;
	public static int ENTOMOVE;
	public static int ENFROMFOOD;
	public static int ENFORBABY;
	public static byte COLOR; 

	//the constructor begins by sending info on all these stats to the parent 		//class, Animal
	public Human (Zone thZone, Landscape thWorld, int x, int y) {
		super (thZone, thWorld, SPEED, SIGHT, SIZE, x, y, COLOR, MAXEN, BABYAGE, 					OLDAGE, NUMBABIES, ENTOMOVE, ENFROMFOOD, ENFORBABY);

		buildActions (thZone);  //set up our schedule
	}

	//here's our schedule; the frequency of the schedule's repeats depends upon the 	//speed of the animal
	public Object buildActions (Zone thZone) {
		schedule = new ScheduleImpl (thZone, speed);
		try {
			schedule.at$createActionTo$message (0, this, 
						new Selector (getClass (), "takeStep", false));
		}  
		catch (Exception e) {
			e.printStackTrace (System.err);
			System.exit (1);
		}

		return this;
	}

	//each time it takes a turn, assuming it is still alive, the animal updates 	//age, energy, and alive; decides whether or not it wants to move and then 	//moves in the direction of more tempting food if it does; eats the food; and 	//grows
	public void takeStep () {
		if (super.alive) {
			this.age = super.age;
			this.energy = super.energy;
			this.alive = true;

			if (decideToMove ())
				moveToBestFood ();

			eatFood ();
			grow ();
		} else
			this.alive = false;
	}

	//used to determine whether the human will move during a given time step; 	//humans usually stay where they are if there is food remaining, but if the 	//food is fairly low and there is more food nearby and they have a good amount 	//of energy, they will move
	private boolean decideToMove () {
		int foodHere = world.getFood (x, y);
		int nearestFood; //the distance to the nearest food, not 							//counting the food directly under the human
		int randval; //used to determine whether the Human will move away from a 								//relatively small amount of food

		if (foodHere == 0) //we're definitely moving
			return true;
		else if (foodHere > 2) //no need to move
			return false;
		else { //now we gotta decide
			nearestFood = getNearestFood (3);
			randval = Globals.env.uniformIntRand.getIntegerWithMin$withMax 
												(4, 15);

			if ((nearestFood < 3) && (energy > randval))
				return true;
			else
				return false;
		}
	}

	//here we activate the animal and its schedule
	public Activity activateIn (Swarm papaswarm) {
		super.activateIn (papaswarm);
		schedule.activateIn (this);
		return getActivity ();
	}
}

