//  2d Feeding Optimization
//  Copyright 8/18/00 Andrew Lovett, under the supervision of Louis Gross
//  Check the file Info/CopyrightInfo.txt for copyright information

//This observer swarm is different from Overlord.  Instead of setting up graphics and //then running the simulation a single time, it runs the program without graphics //several times using various different methods for dumping food in an attempt to //determine to the optimal method.

import swarm.Globals;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.FileReader;
import java.io.BufferedReader;

public class Optimizer {

	//we use this to measure the amount of time the simulations take
	private static long thTime; 

	//an array containing the average info from a run of the simulation for each 	//dump type
	public Info[] averageInfos; 

	//heres the one that holds info from the latest simulation run
	public Info simuInfo;

	public static int numTypes; //the total number of dump types
	
	//this array holds the number of times the program will run through the 	//simulation for each dump type; the first element of this array refers to dump 	//type 1, the second refers to dump type 2, etc; if you wish to modify the 	//number of times each method will be tried, you can do so from the input file 	//SimulationData.txt
	private static int[] timesForMethod;

	//info that will be found in the output file
	public int maxBirthRateType; //food dump type with the highest birth rate
	public double maxBirthRate = -1;

	public int minDeathRateType;
	public double minDeathRate = Double.POSITIVE_INFINITY;

	public int maxAnimalYearsType;
	public int maxAnimalYears = -1;

	public int maxCowViabilityType;
	public double maxCowViability = -1;

	public int maxHorseViabilityType;
	public double maxHorseViability = -1;

	public int maxMonkeyViabilityType;
	public double maxMonkeyViability = -1;

	public int maxHumanViabilityType;
	public double maxHumanViability = -1;

	//the constructor
	public Optimizer () {
		numTypes = Space2d.NUM_DUMP_METHODS;
		timesForMethod = new int[numTypes];

		//now get various info from a file
		try {
			BufferedReader in = new BufferedReader (new FileReader 										("Data\\SimulationData.txt"));

			in.readLine (); //this is frequently used to skip over lines of 												//text in the file
			int counter = 0; //keeps track of our placement within the array
			String holder; //holds a string from the input file

			//read lines from the file until you come to the line after the 				//last number; this line starts with "Simulation"
			while (!((holder = in.readLine ()).startsWith ("Simulation"))) {
				timesForMethod[counter] = Integer.parseInt (holder);
				counter++;
			}			

			Middleman.SIMU_SIZE = Integer.parseInt (in.readLine ());
			in.readLine ();

			Middleman.START_TIME = Integer.parseInt (in.readLine ());
			in.readLine ();
	
			Middleman.VIABILITY_LEVEL = Integer.parseInt (in.readLine ());

			in.close ();
		}
		catch (Exception e) {
			System.err.println 
						("You got a problem with your input file here.");
			System.exit (1);
		}

		averageInfos = new Info[numTypes];

		for (int i = 0; i <= numTypes - 1; i++)
			averageInfos[i] = new Info (i + 1);

		Landscape.isGraphical = false;
	}

	//the function the display schedule calls, it updates the display, tells the 	//modelswarm to draw food the first time this timestep it is asked to do so, 	//updates Landscape's Time and Total_Animal fields, etc
	public void runSimulation (int i, int dtype) {
		System.out.println ("Beginning trial number " + i);
		
		//create an instance of info so that Middleman can put all simulation 			//info into it
		simuInfo = new Info (dtype);
		Middleman swarmRunner = new Middleman 
						(Globals.env.globalZone, i, dtype, simuInfo);

		swarmRunner.buildObjects ();
		swarmRunner.buildActions ();
		swarmRunner.activateIn (null);
		swarmRunner.go ();
		swarmRunner.drop ();
	}
	
	//adds the info from the most recent simulation run to the appropriate element 	//of averageInfos; after all the info has been added, we will divide those 	//numbers which should be averages by numRuns
	public void addInfo () {
		int index = simuInfo.dumpType - 1;

		averageInfos[index].totalTime = simuInfo.totalTime;

		averageInfos[index].startTime = simuInfo.startTime;

		averageInfos[index].animalYears += simuInfo.animalYears;

		averageInfos[index].viabilityLevel = simuInfo.viabilityLevel;

		averageInfos[index].cowViability += simuInfo.cowViability;
		averageInfos[index].horseViability += simuInfo.horseViability;
		averageInfos[index].monkeyViability += simuInfo.monkeyViability;
		averageInfos[index].humanViability += simuInfo.humanViability;

		averageInfos[index].deathRate += simuInfo.deathRate;
		averageInfos[index].birthRate += simuInfo.birthRate;
		averageInfos[index].deathDist += simuInfo.deathDist;
	}

	//after all the info from all the runs has been added to averageInfos, we 	//divide the appropriate fields by the number of runs to get our averages
	public void getAverages () {
		for (int i = 0; i <= numTypes - 1; i++) {
			int numRuns = timesForMethod[i]; //the number of times this 									//particular method has been tried
			if (numRuns > 0) {
				averageInfos[i].animalYears /= numRuns;
				averageInfos[i].cowViability /= numRuns;
				averageInfos[i].horseViability /= numRuns;
				averageInfos[i].monkeyViability /= numRuns;
				averageInfos[i].humanViability /= numRuns;
				averageInfos[i].deathRate /= numRuns;
				averageInfos[i].birthRate /= numRuns;
				averageInfos[i].deathDist /= numRuns;	

				//and now to compute info for other variables
				if (averageInfos[i].animalYears > maxAnimalYears) {
					maxAnimalYears = averageInfos[i].animalYears;
					maxAnimalYearsType = i + 1;
				}
				if (averageInfos[i].cowViability > maxCowViability) {
					maxCowViability = averageInfos[i].cowViability;
					maxCowViabilityType = i + 1;
				}
				if (averageInfos[i].horseViability > maxHorseViability) {
					maxHorseViability = averageInfos[i].horseViability;
					maxHorseViabilityType = i + 1;
				}
				if (averageInfos[i].monkeyViability > maxMonkeyViability) {
					maxMonkeyViability = averageInfos[i].monkeyViability;
					maxMonkeyViabilityType = i + 1;
				}
				if (averageInfos[i].humanViability > maxHumanViability) {
					maxHumanViability = averageInfos[i].humanViability;
					maxHumanViabilityType = i + 1;
				}
				if (averageInfos[i].birthRate > maxBirthRate) {
					maxBirthRate = averageInfos[i].birthRate;
					maxBirthRateType = i + 1;
				}
				if (averageInfos[i].deathRate < minDeathRate) {
					minDeathRate = averageInfos[i].deathRate;
					minDeathRateType = i + 1;
				}
			}//end if

		}//end of for loop
	}

	//send all info to a text file after the simulations have been completed
	public void reportInfo () {
		PrintWriter out = null; //used to output info to a file
	
		//now we set up to write info to a file
		try {
			out = new PrintWriter (new FileWriter ("output.txt"));
		} catch (Exception e) {
			System.err.println ("IO Error");
		}
		
		out.println ("These simulations took " + (thTime / 1000) + 
									" seconds to complete...");
		out.println ("");
		out.println ("");
		for (int i = 0; i <= numTypes - 1; i++) {
			if (timesForMethod[i] > 0) {
				out.println ("Using dump type " + (i + 1) + "...");
				out.println ("");
				out.println ("This run lasted " + averageInfos[i].totalTime + 
											" time steps");
				out.println ("Measurements began at " + 
									averageInfos[i].startTime);
				out.println ("The viability level was set to " + 
								averageInfos[i].viabilityLevel);
				out.println ("");
				out.println ("Over the course of " + timesForMethod[i] + 
					" runs, the average measurements were as follows...");
				out.println ("Total Animal Years: " + 													averageInfos[i].animalYears);
				out.println (""); 
				out.println ("Cow Viability: " + 
									averageInfos[i].cowViability);
				out.println ("Horse Viability: " + 
								averageInfos[i].horseViability);
				out.println ("Monkey Viability: " + 
								averageInfos[i].monkeyViability);
				out.println ("Human Viability: " + 
								averageInfos[i].humanViability);
				out.println ("");
				out.println ("Birth Rate: " + averageInfos[i].birthRate);
				out.println ("Death Rate: " + averageInfos[i].deathRate);
				out.println ("Death Range (difference between the death rate in the region with the highest death rate and the death rate in the region with the lowest): " + averageInfos[i].birthRate);
				out.println ("");
				out.println ("");
			} //end if
		} //end of for loop

		//Info on max/mins
		out.println ("Food Dump Type with Max Animal Years: " + 													maxAnimalYearsType);
		out.println ("Max Animal Years: " + maxAnimalYears);
		out.println ("");
		out.println ("Food Dump Type with Max Birth Rate: " +
										maxBirthRateType);
		out.println ("Max Birth Rate: " + maxBirthRate);
		out.println ("");
		out.println ("Food Dump Type with Min Death Rate: " +
										minDeathRateType);
		out.println ("Min Death Rate: " + minDeathRate);
		out.println ("");
		out.println ("Food Dump Type with Max Cow Viability: " +
										maxCowViabilityType);
		out.println ("Max Cow Viability: " + maxCowViability);
		out.println ("");
		out.println ("Food Dump Type with Max Horse Viability: " +
										maxHorseViabilityType);
		out.println ("Max Horse Viability: " + maxHorseViability);
		out.println ("");
		out.println ("Food Dump Type with Max Monkey Viability: " +
										maxMonkeyViabilityType);
		out.println ("Max Monkey Viability: " + maxMonkeyViability);
		out.println ("");
		out.println ("Food Dump Type with Max Human Viability: " +
										maxHumanViabilityType);
		out.println ("Max Human Viability: " + maxHumanViability);


		out.close ();
	}


	//here we run the actual program
	//we initialize swarm, create the overswarm, tell it to build its actions and 	//objects, activate it, and we're off
	public static void runOptimization () { 		
		Optimizer overseer = new Optimizer ();

		//measure the amount of time the simulations take
		thTime = System.currentTimeMillis ();
		
		int num = 0; //keep track of how many trial runs we've done
		for (int i = 0; i <= overseer.numTypes - 1; i++)
			for (int j = 1; j <= timesForMethod [i]; j++) {
				num++;
				overseer.runSimulation (num, i + 1);
				overseer.addInfo ();
			}

		//so the total time for the simulations was...
		thTime = System.currentTimeMillis () - thTime;
		System.out.println ("Finished in " + (thTime / 1000) + " seconds.");

		overseer.getAverages ();
		overseer.reportInfo ();
		
	}
}
