//  2d Feeding Optimization
//  Copyright 8/18/00 Andrew Lovett, under the supervision of Louis Gross
//  Check the file Info/CopyrightInfo.txt for copyright information

//This class merely stores information about the current simulation state.  It holds //things such as the time, the number of animals currently living, etc.  It also sets //up a probe map to display this information if you are running in graphical mode.

import swarm.Globals;
import swarm.defobj.Zone;
import swarm.objectbase.SwarmImpl;
import swarm.objectbase.VarProbe;
import swarm.objectbase.MessageProbe;
import swarm.objectbase.EmptyProbeMapImpl;

public class SimulationState extends SwarmImpl {

	public int Time = 0; //total number of time steps which have passed
	public char Season; //'U' for Summer, you can guess the rest
	public int Total_Animals = 0; //the total number of living animals
	public int Birth_Count = 0; //the total number of births so far
	public int Death_Count = 0; //total number of deaths so far
	public int Total_Food = 0; //the total amount of food on the grid
	public int Num_Starved = 0; //the number of animals that have starved
	public int Num_OldAged = 0; //the number of animals that have died of 								//old age

	//the number of each animal type currently alive, also in the Probe Window
	public int Total_Cows = Landscape.NUMCOWS;
	public int Total_Koalas = Landscape.NUMKOALAS;
	public int Total_Horses = Landscape.NUMHORSES;
	public int Total_Monkeys = Landscape.NUMMONKEYS;
	public int Total_Humans = Landscape.NUMHUMANS;

	//these control whether you user sees the display and the graphs
	public boolean displayIt = true;
	public boolean animalGraphIt = true;
	public boolean lifeDeathGraphIt = true;

	//the constructor
	public SimulationState (Zone thZone) {
		super (thZone);

		//tell various classes where we are
		Animal.state = this;
		Space2d.state = this;
		Middleman.state = this;
		Overlord.state = this;
		Foodspace.state = this;

		//don't set up the probe display map if we aren't in graphical mode
		if (!Landscape.isGraphical)
			return;

		//And now here's the custom probe map
		//This will tell swarm what variables to give values for in the Probe 			//Window
		class SimulationStateMap extends EmptyProbeMapImpl {
			private VarProbe probeVariable (String name) {
				return Globals.env.probeLibrary.getProbeForVariable$inClass
					(name, SimulationState.this.getClass ());
			}

			private MessageProbe probeMessage (String name) {
       			return 
					Globals.env.probeLibrary.getProbeForMessage$inClass
          				(name, SimulationState.this.getClass ());
      		}

			public SimulationStateMap (Zone aZone, Class thClass) {
				super (aZone, thClass);

				addProbe (probeVariable ("Time"));
				addProbe (probeVariable ("Season"));
				addProbe (probeVariable ("Total_Animals"));
				addProbe (probeVariable ("Total_Cows"));
				addProbe (probeVariable ("Total_Koalas"));
				addProbe (probeVariable ("Total_Horses"));
				addProbe (probeVariable ("Total_Monkeys"));
				addProbe (probeVariable ("Total_Humans"));
				addProbe (probeVariable ("Birth_Count"));
				addProbe (probeVariable ("Death_Count"));
				addProbe (probeVariable ("Total_Food"));
				addProbe (probeVariable ("Num_Starved"));
				addProbe (probeVariable ("Num_OldAged"));

				addProbe (probeMessage ("displayOn:"));
				addProbe (probeMessage ("animalGraphOn:"));
				addProbe (probeMessage ("lifeDeathGraphOn:"));
			}
		}
		//here we actually create the Probe Map and set it to be the map for this 		//class
		Globals.env.probeLibrary.setProbeMap$For 
			(new SimulationStateMap (thZone, getClass ()), getClass ());
	}

	//the following functions return info to read to graphs
	public int getTotalAnimals () {
		return Total_Animals;
	}

	public int getTotalCows () {
		return Total_Cows;
	}

	public int getTotalHorses () {
		return Total_Horses;
	}

	public int getTotalMonkeys () {
		return Total_Monkeys;
	}

	public int getTotalHumans () {
		return Total_Humans;
	}

	public int getBirthCount () {
		return Birth_Count;
	}

	public int getDeathCount () {
		return Death_Count;
	}

	public int getNumStarved () {
		return Num_Starved;
	}

	public int getNumOldAged () {
		return Num_OldAged;
	}


	//the following three functions let the user turn the display and the graphs on 	//and off
	
	public boolean displayOn (boolean isOn) {
		displayIt = isOn;

		return isOn;
	}

	public boolean animalGraphOn (boolean isOn) {
		animalGraphIt = isOn;
	
		return isOn;
	}

	public boolean lifeDeathGraphOn (boolean isOn) {
		lifeDeathGraphIt = isOn;

		return isOn;
	}
}