// WorldObject.h

// Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <space.h>
#import <vision/ThreeD.h>

// The maximum value a square can use: just for the visualization
extern const int colorOffset;

// Class WorldObject. Inherit from Discrete2d
@interface WorldObject : Discrete2d {
  int InitNbObj; // number of objects in the WorldObject at the outset
  id threeDList; // list of 3D objects
}

// init number of objects

-InitNumberOfObj: (int)value;

// set objects
-InitSetObjects: (int)seedValueObjects;

// get number of objects on cell (x, y)
-(int)getObjects: (int)x: (int)y;

// get init number of objects
-(int)getInitObj;

// get a pointer on the list of three D points
-getThreeDList;


@end
