// WorldObject.m

// Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "WorldObject.h"
#import <simtools.h>

const int colorOffset = 31744; //62*512: red, change if you prefer another color

@implementation WorldObject


-InitNumberOfObj: (int)value
{
  InitNbObj = value;

  // we create another list to keep track of the coordinates of the points in the world.
  threeDList = [List create: [self getZone]];

  return self;
}

// set Objects: representation by colors
-InitSetObjects: (int)seedValueObjects
{
  int chosenX, chosenY;
  int i;
  id randGen;
  id uniRand;

  //randGen = [[PMMLCG1 alloc] initSeed: seedValueObjects];	  // seeds from clock
  //uniRand = [[[Uniform alloc] init] setGenerator: randGen];

  // for the generator
  randGen = [PMMLCG1 createBegin: [self getZone]];
  [randGen setStateFromSeed: seedValueObjects];
  randGen = [randGen createEnd]; 
  // for the distribution
  uniRand = [UniformInteger createBegin: [self getZone]];
  [uniRand setGenerator: randGen];
  uniRand = [uniRand createEnd];

  for (i=0; i<InitNbObj; i++) {
    Point3D *pt;

    // random position
    chosenX = [uniRand getIntegerWithMin: 0L withMax: [self getSizeX]-1];
    chosenY = [uniRand getIntegerWithMin: 0L withMax: [self getSizeY]-1];

    //chosenX = [uniRand rMax: [self getSizeX]]; 
    //chosenY = [uniRand rMax: [self getSizeY]];

    while ([self getValueAtX: chosenX Y: chosenY] != 0) { // we check if something is already here
      chosenX = [uniRand getIntegerWithMin: 0L withMax: [self getSizeX]-1];
      chosenY = [uniRand getIntegerWithMin: 0L withMax: [self getSizeY]-1];
      //chosenX = [uniRand rMax: [self getSizeX]]; 
      //chosenY = [uniRand rMax: [self getSizeY]];
    }
    //printf("chosenX = %d, chosenY = %d\n", chosenX, chosenY);
    [self putValue: (int)(colorOffset+1) atX: chosenX Y: chosenY];

    // create a 3D point for the vision simulation
    pt = [Point3D createBegin: [self getZone]];
    pt = [pt createEnd];
    // to express in the 3D system (see vision/extrinsic.h for more informations)
    [pt setParam: 1: chosenX: chosenY: i]; // hypothesis height is equal to 1 by default!
    [threeDList addLast: pt];
    //printf("point %d: x= %d, y= %d, z= %d\n", [[threeDList atOffset: i] sendlabel],
    //                                          [[threeDList atOffset: i] sendx],  
    //                                          [[threeDList atOffset: i] sendy],
    //                                          [[threeDList atOffset: i] sendz]);
  }
  return self;
}

-(int)getObjects: (int)x: (int)y
{
  int numObj;

  numObj = [self getValueAtX: x Y: y];
  numObj -= colorOffset;
  if (numObj < 0) numObj=0; // if it is a location without object, after the substraction
                            // the result is a negative value
  return numObj;
}

-(int)getInitObj
{
  return InitNbObj;
}

-getThreeDList {
  return threeDList;
}

@end
