(define *swarm-environment*
    ((primitive-get-static <swarm.Globals> "env" <swarm.SwarmEnvironment>)))

(define *globalZone* #f)

(define (initSwarm)
    (let ((ary ((primitive-array-new <String>) 1)))
      ((primitive-array-set <String>) ary 0 "--no-init-file")
      ((primitive-virtual-method
        <swarm.SwarmEnvironment>
        "initSwarm"
        <void>
        (<String>
         <String>
         <String>
         <java.lang.String[]>))
       *swarm-environment*
       "test" "0.0" "bug-swarm@santafe.edu" ary))
  (set! *globalZone*
        ((primitive-get-field <swarm.SwarmEnvironment> "globalZone" <swarm.defobj.Zone>) *swarm-environment*)))

(define (get-class obj)
    ((primitive-virtual-method <java.lang.Object> "getClass" <java.lang.Class> ()) obj))

(define (scheduleActionTo schedule t target selector)
    ((primitive-virtual-method <swarm.activity.ScheduleImpl> "at$createActionTo$message" <swarm.activity.ActionTo> (<int> <object> <swarm.Selector>)) schedule t target selector))

(define (swarmActivateIn swarm swarmContext)
    ((primitive-interface-method <swarm.objectbase.Swarm> "activateIn" <swarm.activity.Activity> (<swarm.objectbase.Swarm>)) swarm swarmContext))

(define (scheduleActivateIn schedule swarmContext)
    ((primitive-virtual-method <swarm.activity.ScheduleImpl> "activateIn" <swarm.activity.Activity> (<swarm.objectbase.Swarm>)) schedule swarmContext))

(define (getActivity swarm)
    ((primitive-interface-method <swarm.objectbase.Swarm> "getActivity"
                                 <swarm.activity.Activity> ()) swarm))

(define (getSwarmActivity activity)
    ((primitive-interface-method <swarm.activity.Activity> "getSwarmActivity"
                                 <swarm.activity.SwarmActivity> ()) activity))
(define (run activity)
    ((primitive-interface-method <swarm.activity.SwarmActivity> "run"
                                 <swarm.defobj.Symbol> ()) activity))

(define (getCurrentTime)
    ((primitive-virtual-method <swarm.SwarmEnvironment> "getCurrentTime"
                               <int> ()) *swarm-environment*))

(define (terminate)
    (let ((activity
           ((primitive-virtual-method <swarm.SwarmEnvironment> 
                                      "getCurrentSwarmActivity"
                                      <swarm.activity.SwarmActivity> ())
            *swarm-environment*))
          (terminate-func
           (primitive-virtual-method <swarm.activity.Activity> "terminate"
                                     <void> ())))
      (terminate-func activity)))

(define (make-repeating-schedule swarm repeatInterval)
    ((primitive-constructor <swarm.activity.ScheduleImpl>
                           (<swarm.defobj.Zone> <int>))
     swarm repeatInterval))

(define (make-schedule swarm)
    (make <swarm.activity.ScheduleImpl> swarm))

(define (selector target sym)
    (make <swarm.Selector> (get-class target) (symbol->string sym) #f))
