package swarmxml;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ibm.xml.dom.ElementImpl;
import com.ibm.xml.dom.DocumentImpl;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Hashtable;
import java.text.BreakIterator;
import java.lang.reflect.Field;

import swarm.activity.ActionGroup;
import swarm.activity.ActionGroupImpl;
import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;
import swarm.objectbase.Swarm;
import swarm.objectbase.SwarmImpl;
import swarm.simtoolsgui.GUISwarmImpl;
import swarm.simtoolsgui.GUISwarm;

import swarm.space.Grid2dImpl;
import swarm.space.Grid2d;
import swarm.space.Discrete2d;
import swarm.space.Object2dDisplay;
import swarm.space.Object2dDisplayImpl;
import swarm.space.Value2dDisplay;
import swarm.space.Value2dDisplayImpl;

import swarm.gui.Colormap;
import swarm.gui.ZoomRasterImpl;
import swarm.gui.ZoomRaster;

import swarm.Selector;
import swarm.Globals;

import heatbugs.HeatSpace;

import excel9.*;
import com.ms.com.*; // Variant & exception support. 

public class SwarmProcessorExcel extends SwarmProcessorPlain implements SwarmProcessor {
  Variant vEmpty;
  SeriesCollection series;
  _Worksheet sheet;
  Chart chart;
  int column;
    
  public void setupExcel () {
    // Force COM objects to be created on the current thread.
    // Otherwise, older VMs might not release all references
    // and Excel might continue to run after you shutdown.
    ComLib.declareMessagePumpThread();
	
    // Launch Excel 
    vEmpty = new Variant();
    vEmpty.noParam();
    Application xlApp = new Application();
    xlApp.setVisible(0,true); // 1st param is LCID, Locale ID
    
    // Get the workbook object via the object model.
    Workbooks books = xlApp.getWorkbooks();
    _Workbook book = books.Add(vEmpty,0);
    
    // Get the first sheet.		
    Sheets sheets = (Sheets)book.getSheets();
    sheet = (_Worksheet)sheets.getItem(new Variant(1));
    
    objectRegistry.put ("excel", this);
  }

  public void setupExcelChart () {
    double Left = 72.; // location in points
    double Top = 144.;
    double Width = 350.;
    double Height = 250.;
    ChartObjects chartobjects = 
	 (ChartObjects)sheet.ChartObjects(vEmpty,0); // explicit typecast
    ChartObject chartobject = chartobjects.Add(Left, Top, Width, Height);
    Range range;

    // Set the location and size.
    chart = chartobject.getChart();
 
    series = (SeriesCollection) chart.SeriesCollection (vEmpty, 0);
  }

  public void addHeatbugUnhappinessColumn () {
    int i;
    Range range;
    Range range2;
    Variant columnVariant;

    range = sheet.getCells ();
    columnVariant = new Variant (column);
    swarm.collections.ListIndex index = agentList.listBegin (Globals.env.globalZone);
    Object obj;

    i = 0;
    while ((obj = index.next ()) != null) {
	range.setItem (new Variant (i + 1), columnVariant,
		       new Variant (String.valueOf (((heatbugs.Heatbug) obj).getUnhappiness ())));
	i++;
    }
    index.drop ();
    range.setItem (new Variant (100 + 1), columnVariant,
	           new Variant ("=AVERAGE(" + 
		                "R" + 1 + "C" + column +
				":" + 
				"R" + 100 + "C" + column +
                                ")"));
    range = range.getRange (new Variant ("A101"),
			    new Variant ("A101")).getEntireRow ();
    chart.ChartWizard(new Variant (range),
	              new Variant(4),    // Gallery
		      vEmpty,             // Format
		      new Variant(1),     // PlotBy
		      new Variant(0),     // CategoryLabels
		      new Variant(0),     // SeriesLabels
		      new Variant(true),  // HasLegend
		      new Variant("Average Unhappiness"), //Title
		      new Variant("Time"), //CategoryTitle
		      new Variant("Unhappiness"), //ValueTitle
		      vEmpty,             // ExtraTitle
		      0                   // LCID(localeID)
		      );

    column++;
  }
  
  public SwarmProcessorExcel (Document document) {
    super (document);
    column = 1;

    setupExcel ();  
    setupExcelChart ();
  }
}


