package swarmxml;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ibm.xml.dom.ElementImpl;
import com.ibm.xml.dom.DocumentImpl;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Hashtable;
import java.text.BreakIterator;
import java.lang.reflect.Field;

import swarm.activity.ActionGroup;
import swarm.activity.ActionGroupImpl;
import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;
import swarm.objectbase.Swarm;
import swarm.objectbase.SwarmImpl;
import swarm.simtoolsgui.GUISwarmImpl;
import swarm.simtoolsgui.GUISwarm;

import swarm.space.Grid2dImpl;
import swarm.space.Grid2d;
import swarm.space.Discrete2d;
import swarm.space.Object2dDisplay;
import swarm.space.Object2dDisplayImpl;
import swarm.space.Value2dDisplay;
import swarm.space.Value2dDisplayImpl;

import swarm.gui.Colormap;
import swarm.gui.ZoomRasterImpl;
import swarm.gui.ZoomRaster;

import swarm.Selector;
import swarm.Globals;

import heatbugs.HeatSpace;

public class SwarmProcessorPlain implements SwarmProcessor {
  Document document;
  Hashtable classRegistry;
  public Hashtable objectRegistry;
  swarm.collections.List agentList;

  public Object getObject (String name) {
    return objectRegistry.get (name);
  } 

  public void processGrid2dElement (Element elem) {
    int width = Integer.parseInt (elem.getAttribute ("width"));
    int height = Integer.parseInt (elem.getAttribute ("height"));
    
    objectRegistry.put (elem.getAttribute ("id"),
                        new Grid2dImpl (Globals.env.globalZone,
                                        width,
                                        height));
  }

  public void processColormapElement (Element elem) {
    objectRegistry.put (elem.getAttribute ("id"),
                        new heatbugs.Colormap ());
  }

  public void processHeatspaceElement (Element elem) {
    int width = Integer.parseInt (elem.getAttribute ("width"));
    int height = Integer.parseInt (elem.getAttribute ("height"));
    String name = elem.getAttribute ("id");
    double diffuseConstant =
	new Double (elem.getAttribute ("diffuseConstant")).doubleValue ();
    double evaporationRate =
	new Double (elem.getAttribute ("evaporationRate")).doubleValue ();
    HeatSpace heatspace = new HeatSpace (Globals.env.globalZone,
                                         width,
                                         height,
                                         diffuseConstant,
                                         evaporationRate);
    objectRegistry.put (name, heatspace);
  }

  public void processValue2dDisplayElement (Element elem) {
    ZoomRaster raster =
      (ZoomRaster) objectRegistry.get (elem.getAttribute ("raster"));
    Colormap colormap =
      (Colormap) objectRegistry.get (elem.getAttribute ("colormap"));
    Discrete2d space = 
      (Discrete2d) objectRegistry.get (elem.getAttribute ("space"));
    int factor = Integer.parseInt (elem.getAttribute ("factor"));
    int colorOffset = Integer.parseInt (elem.getAttribute ("colorOffset"));
    Value2dDisplay display = new Value2dDisplayImpl (Globals.env.globalZone,
                                                     raster, colormap, space);
    
    display.setDisplayMappingM$C (factor, colorOffset);
    objectRegistry.put (elem.getAttribute ("id"), display);
  }


  public void processObject2dDisplayElement (Element elem) {
    swarm.collections.List collection =
      (swarm.collections.List) 
      objectRegistry.get (elem.getAttribute ("collection"));
    ZoomRaster raster = 
      (ZoomRaster) objectRegistry.get (elem.getAttribute ("raster"));
    Discrete2d space =
      (Discrete2d) objectRegistry.get (elem.getAttribute ("space"));
    String selectorName = elem.getAttribute (elem.getAttribute ("message"));

    try {
      Selector selector = new Selector (collection.getFirst ().getClass (),
                                        "drawSelfOn",
                                        false);
      objectRegistry.put (elem.getAttribute ("id"),
                          new Object2dDisplayImpl (Globals.env.globalZone,
                                                   raster, space, selector));
    } catch (Exception e) {
      e.printStackTrace (System.err);
    }
  }
  
  public void processZoomRasterElement (Element elem) {
    int width = Integer.parseInt (elem.getAttribute ("width"));
    int height = Integer.parseInt (elem.getAttribute ("height"));
    Colormap colormap =
      (Colormap) objectRegistry.get (elem.getAttribute ("colormap"));
    int zoomFactor = Integer.parseInt (elem.getAttribute ("zoomFactor"));
    String name = elem.getAttribute ("id");
    ZoomRaster zoomRaster = new ZoomRasterImpl (Globals.env.globalZone,
                                                "worldRaster");
    zoomRaster.setColormap (colormap);
    zoomRaster.setZoomFactor (4);
    zoomRaster.setWidth$Height (width, height);
    zoomRaster.setWindowTitle ("Heat World");
    zoomRaster.pack ();
    
    objectRegistry.put (name, zoomRaster);
  }
  
  public void processEnvironmentElement (Swarm swarm, Element envElem) {
    NodeList nl = envElem.getChildNodes ();
    int i;
    Node node;

    for (i = 0, node = nl.item (i); node != null; i++, node = nl.item (i))
      {
        if (node.getNodeType () == Node.ELEMENT_NODE)
          {
            Element elem = (Element) node;
            String name = elem.getNodeName ();
            
            if (name.equals ("HeatbugsColormap"))
              processColormapElement (elem);
            else if (name.equals ("Grid2d"))
              processGrid2dElement (elem);
            else if (name.equals ("HeatSpace"))
              processHeatspaceElement (elem);
            else if (name.equals ("Value2dDisplay"))
              processValue2dDisplayElement (elem);
            else if (name.equals ("Object2dDisplay"))
              processObject2dDisplayElement (elem);
            else if (name.equals ("ZoomRaster"))
              processZoomRasterElement (elem);
          }
      }
  }

  
  public void processGUIEnvironmentElement (Swarm swarm, Element envElem) {
    NodeList nl = envElem.getChildNodes ();
    int i;
    Node node;

    for (i = 0, node = nl.item (i); node != null; i++, node = nl.item (i))
      {
        if (node.getNodeType () == Node.ELEMENT_NODE)
          {
            Element elem = (Element) node;
            String name = elem.getNodeName ();
            
            if (name.equals ("HeatbugsColormap"))
              processColormapElement (elem);
            else if (name.equals ("Value2dDisplay"))
              processValue2dDisplayElement (elem);
            else if (name.equals ("Object2dDisplay"))
              processObject2dDisplayElement (elem);
            else if (name.equals ("ZoomRaster"))
              processZoomRasterElement (elem);
          }
      }
  }
  public void processUniformRandomElement (List attributeList, Element elem) {
    String name = elem.getAttribute ("name");
    int min = Integer.parseInt (elem.getAttribute ("min"));
    int max = Integer.parseInt (elem.getAttribute ("max"));
    
    attributeList.add (new UniformRandomInt (name, min, max));
  }

  public void processDoubleConstantElement (List attributeList, Element elem) {
    double val = new Double (elem.getAttribute ("value")).doubleValue ();
    
    attributeList.add (new DoubleConstant (elem.getAttribute ("name"), val));
  }

  public void processByteConstantElement (List attributeList, Element elem) {
    byte val = Byte.parseByte (elem.getAttribute ("value"));
    
    attributeList.add (new ByteConstant (elem.getAttribute ("name"), val));
  }
        
  public void processClassElement (Element classElem) {
    int i;
    NodeList children = classElem.getChildNodes ();
    Node node;
    List attributeList = new LinkedList ();
    
    for (i = 0, node = children.item (i);
         node != null; 
         i++, node = children.item (i)) {
      if (node.getNodeType () == Node.ELEMENT_NODE)
        {
          Element elem = (Element) node;
          String name = elem.getNodeName ();
          
          if (name.equals ("uniformRandom"))
            processUniformRandomElement (attributeList, elem);
          else if (name.equals ("byteConstant"))
            processByteConstantElement (attributeList, elem);
          else if (name.equals ("doubleConstant"))
            processDoubleConstantElement (attributeList, elem);
        }
    }
    classRegistry.put (classElem.getAttribute ("name"), attributeList);
  }
                                   
  public void processClassesElement (Swarm swarm, Element classesElem) {
    int i;
    NodeList children = classesElem.getChildNodes ();
    Node node;
    
    for (i = 0, node = children.item (i);
         node != null; 
         i++, node = children.item (i)) {
      if (node.getNodeType () == Node.ELEMENT_NODE)
        processClassElement ((Element) node);
    }
  }

  public void applyAttributes (Object obj) {
    Class clazz = obj.getClass ();
    String name = clazz.getName ();
    List attributeList = (List) classRegistry.get (name);
    ListIterator listIterator = attributeList.listIterator ();

    while (listIterator.hasNext ())
      {
        Variable ivar = (Variable) listIterator.next ();

        try {
          String ivarName = ivar.getName ();
          Field field = clazz.getDeclaredField (ivarName);
          
          if (ivar instanceof ByteConstant)
            field.setByte (obj, ((ByteConstant) ivar).getValue ());
          if (ivar instanceof DoubleConstant)
            field.setDouble (obj, ((DoubleConstant) ivar).getValue ());
          else if (ivar instanceof UniformRandomInt) {
            UniformRandomInt randObj = (UniformRandomInt) ivar;
            int min = randObj.getMin ();
            int max = randObj.getMax ();
            int val = 
              Globals.env.uniformIntRand.getIntegerWithMin$withMax (min, max);
            field.setInt (obj, val);
          }
        }
        catch (Exception e) {
          e.printStackTrace (System.err);
        }
      }
  }

  public void processAgentsElement (Swarm swarm, Element el) {
    int count = Integer.parseInt (el.getAttribute ("count"));
    String className = el.getAttribute ("class");
    String spaceName = el.getAttribute ("populate");
    Grid2d space = null;
    int width = 0, height = 0;
    int i;

    agentList = new swarm.collections.ListImpl (Globals.env.globalZone);

    if (spaceName != null)
      {
        space = (Grid2d) objectRegistry.get (spaceName);
        width = space.getSizeX ();
        height = space.getSizeY ();
      }
    
    
    for (i = 0; i < count; i++) {
      try {
        Object agent = Class.forName (className).newInstance ();
        
        applyAttributes (agent);

        agentList.addLast (agent);
        if (space != null)
          {
            int x =
              Globals.env.uniformIntRand.getIntegerWithMin$withMax (0, width);
            int y =
              Globals.env.uniformIntRand.getIntegerWithMin$withMax (0, height);
            
            ((heatbugs.Heatbug) agent).setX$Y (x, y);
            // space.putObject$atX$Y (agent, x, y);
          }
      } catch (Exception e) {
        System.err.println ("Can't find class " + className);
      }
    }
    objectRegistry.put (el.getAttribute ("id"), agentList);
  }

  public void processAction (Object container,
                             Element actionElement,
                             boolean forEachFlag) {
    String targetName = actionElement.getAttribute ("target");
    Object target = objectRegistry.get (targetName);
    String message = actionElement.getAttribute ("message");

    try {
      Selector selector;

      if (forEachFlag) {
        selector = new Selector (((swarm.collections.List) target).
                                 getFirst ().getClass (),
                                 message, false);
        if (container instanceof Schedule) {
          int tVal = Integer.parseInt (actionElement.getAttribute ("time"));
          
          ((Schedule) container)
            .at$createActionForEach$message (tVal, target, selector);
        } else {
          ((ActionGroup) container).
            createActionForEach$message (target, selector);
        }
      } else {
        selector = new Selector (target.getClass (), message, false);
        if (container instanceof Schedule) {
          int tVal = Integer.parseInt (actionElement.getAttribute ("time"));
          
          ((Schedule) container)
            .at$createActionTo$message (tVal, target, selector);
        } else {
          ((ActionGroup) container).createActionTo$message (target,
                                                            selector);
        }
      }
    } catch (Exception e) {
      e.printStackTrace (System.err);
    }
  }
  
  public void processActions (Object container, Element el) {
    NodeList children = el.getChildNodes ();
    Node node;
    int i;
  
    for (i = 0, node = children.item (i);
         node != null; 
         i++, node = children.item (i))
      {
        if (node.getNodeType () == Node.ELEMENT_NODE) {
          if (node.getNodeName ().equals ("ActionForEach"))
            processAction (container, (Element) node, true);
          else if (node.getNodeName ().equals ("ActionTo"))
            processAction (container, (Element) node, false);
        }
      }
  }
  
  public void processActionGroups (Schedule schedule,
                                    Element scheduleElem) {
    NodeList children = scheduleElem.getChildNodes ();
    Node node;
    int i;
    
    for (i = 0, node = children.item (i);
         node != null; 
         i++, node = children.item (i))
      if (node.getNodeType () == Node.ELEMENT_NODE)
        processActionGroupElement (schedule, (Element) node);
  }
  
  public void processActionGroupElement (Schedule schedule, Element elem) {
    ActionGroup actionGroup =
      new ActionGroupImpl (Globals.env.globalZone);
    
    processActions (actionGroup, elem);
    int tVal = Integer.parseInt (elem.getAttribute ("time"));
    schedule.at$createAction (tVal, actionGroup);
  }
      
  public void processScheduleElement (Swarm swarm, Element elem) {
    String repeatIntervalString = elem.getAttribute ("repeatInterval");
    Schedule schedule;
    
    if (repeatIntervalString != null)
      schedule = new ScheduleImpl (Globals.env.globalZone,
                                   Integer.parseInt (repeatIntervalString));
    else
      schedule = new ScheduleImpl (Globals.env.globalZone);
    
    processActionGroups (schedule, elem);
    processActions (schedule, elem);
    schedule.activateIn (swarm);
  }
    
  public void processSwarm (Swarm parentSwarm, Element swarmElem) {
    NodeList nl;
    Swarm swarm;
    
    if (swarmElem.getNodeName ().equals ("GUISwarm"))
      {
        GUISwarm guiSwarm = new basicGUISwarmImpl (Globals.env.globalZone);

        guiSwarm.buildObjects ();
        guiSwarm.buildActions ();
        swarm = guiSwarm;
      }
    else
      swarm = new SwarmImpl (Globals.env.globalZone);

    swarm.activateIn (parentSwarm);
    
    NodeList children = swarmElem.getChildNodes ();
    Node node;
    int i;
  
    for (i = 0, node = children.item (i);
         node != null; 
         i++, node = children.item (i))
      {
        if (node.getNodeType () == Node.ELEMENT_NODE) {
          Element elem = (Element) node;
          String name = node.getNodeName ();
          
          if (name.equals ("Swarm"))
            processSwarm (swarm, elem);
          if (name.equals ("environment"))
            processEnvironmentElement (swarm, elem);
          else if (name.equals ("gui-environment"))
            processGUIEnvironmentElement (swarm, elem);
          else if (name.equals ("classes"))
            processClassesElement (swarm, elem);
          else if (name.equals ("agents"))
            processAgentsElement (swarm, elem);
          else if (name.equals ("Schedule"))
            processScheduleElement (swarm, elem);
        }
      }
    if (swarmElem.getNodeName ().equals ("GUISwarm"))
      ((GUISwarm) swarm).go ();
    else if (parentSwarm == null)
      swarm.getActivity ().run ();
  }

  public void processSwarmModel (Element swarmElem) {
    NodeList children = swarmElem.getChildNodes ();
    Node node;
    int i;
  
    for (i = 0, node = children.item (i);
         node != null; 
         i++, node = children.item (i))
      if (node.getNodeType () == Node.ELEMENT_NODE)
        processSwarm (null, (Element) node);
  }
  
  public SwarmProcessorPlain (Document document) {
    classRegistry = new Hashtable ();
    objectRegistry = new Hashtable ();
    this.document = document;
  }
}
