// Copyright  1995-2000 Swarm Development Group.
// No warranty implied, see LICENSE for terms.

#import "ModelSwarm.h"
#import <simtools.h>
#import <random.h>
#import <gui.h>
#import <collections.h>
#import "SortingAnt.h"

// Global variables: simulation parameters. This will be replaced with
// a cleaner mechanism.
int numAnts = 100;
double spaceDensity = 0.15;
int worldSize = 70;
int parcelTypes = 2;
double pickupExponent = 0.25;

@implementation ModelSwarm

- buildObjects
{
  id <Pixmap> antPixmap, carryPixmap;
  int i;

  [super buildObjects];

  // Create a colormap for display (will go in higher level display objects)
  colormap = [Colormap create: globalZone];
  [colormap setColor: 0 ToGrey: 0.7];
  [colormap setColor: 1 ToRed: 0.7 Green: 0.7 Blue: 0];
  [colormap setColor: 2 ToName: "black"];
  [colormap setColor: 3 ToName: "firebrick"];
  [colormap setColor: 4 ToName: "forestgreen"];
  [colormap setColor: 5 ToName: "purple"];
  [colormap setColor: 6 ToName: "blue"];
  [colormap setColor: 7 ToName: "springgreen"];
  [colormap setColor: 8 ToName: "orange"];

  // create a window for display (will go in higher level display objects)
  z = [ZoomRaster create: globalZone];
  [z setColormap: colormap];
  [z setZoomFactor: 8];
  [z setWidth: worldSize Height: worldSize];
  [z setWindowTitle: "Sorting Ant World"];
  [z pack];
  [z erase];

  // set up the sort space
  sortSpace = [SortSpace createBegin: globalZone];
  [sortSpace setSizeX: worldSize Y: worldSize];
  [sortSpace setDensity: spaceDensity];
  [sortSpace setNumTypes: parcelTypes];
  sortSpace = [sortSpace createEnd];

  // set up the grid to represent agent position
  world = [Grid2d createBegin: globalZone];
  [world setSizeX: worldSize Y: worldSize];
  world = [world createEnd];

  {
    const char *dataPath = [arguments getAppDataPath];

    antPixmap = [[[[Pixmap createBegin: globalZone]
                    setDirectory: dataPath]
                   setFile: "ant.png"] createEnd];
    [antPixmap setRaster: z];
    carryPixmap = [[[[Pixmap createBegin: globalZone]
                      setDirectory: dataPath]
                     setFile: "antcarry.png"] createEnd];
    [carryPixmap setRaster: z];
  }

  antList = [List create: self];

  [world setOverwriteWarnings: 0];
  // unfortunate, see ant step
  for (i = 0; i < numAnts; i++)
    {
      SortingAnt *ant;
      
      ant = [SortingAnt createBegin: self];
      [ant setWorld: world Space: sortSpace];
      [ant setX: [uniformIntRand getIntegerWithMin: 0 withMax: worldSize - 1]
           Y: [uniformIntRand getIntegerWithMin: 0 withMax: worldSize - 1]];
      [ant setColors: 0 : 1];
      [ant setPixmaps: carryPixmap :antPixmap];
      ant = [ant createEnd];
      [antList addLast: ant];
    }
  

  // Create an object to display the ants.
  antDisplayer = [Object2dDisplay createBegin: self];
  [antDisplayer setDisplayWidget: z];
  [antDisplayer setDiscrete2dToDisplay: world];
  [antDisplayer setDisplayMessage: M(drawSelfOn:)];
  [antDisplayer setObjectCollection: antList];
  antDisplayer = [antDisplayer createEnd];

  // Register it with the raster widget.
  [z setButton: ButtonRight Client: antDisplayer Message: M(makeProbeAtX:Y:)];

  return self;
}

- buildActions
{
  [super buildActions];

  simSchedule = [Schedule createBegin: self];
  [simSchedule setRepeatInterval: 1];
  simSchedule = [simSchedule createEnd];
  
  [simSchedule at: 0 createActionForEach: antList message: M(step)];
  return self;
}

- updateDisplay
{
  [antList forEach: M(step)];
  [z erase];
  [sortSpace drawSelfOn: z];
  [antDisplayer display];
  [z drawSelf];

  return self;
}

- activateIn: swarmContext
{
  [super activateIn: swarmContext];

  [simSchedule activateIn: self];

  return [self getActivity];
} 

@end
