// Copyright  1995-2000 Swarm Development Group.
// No warranty implied, see LICENSE for terms.

#include "ObserverSwarm.h"
#include "ModelSwarm.h"

int displayFrequency = 1;

@implementation ObserverSwarm

- buildObjects
{
  [super buildObjects];

  modelSwarm = [ModelSwarm create: self];
  [modelSwarm buildObjects];
  return self;
}

- buildActions
{
  [super buildActions];
  
  displayActions = [ActionGroup create: self];
  [displayActions createActionTo: modelSwarm message: M(updateDisplay)];
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: actionCache message: M(doTkEvents)];

  displaySchedule = [Schedule createBegin: self];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  
  [displaySchedule at: 0 createAction: displayActions];

  [modelSwarm buildActions];
  
  return self;
}

- activateIn: swarmContext
{
  [super activateIn: swarmContext];
  
  [modelSwarm activateIn: self];
  [displaySchedule activateIn: self];

  return [self getActivity];
}

@end

