#import <space.h>
#import "Fire.h"
#import "Forest.h"
#import "Tree.h"

#import <random.h>

@implementation Fire

- setWorldSize: (int)aSize
{
  worldSize = aSize;
  return self;
}

- setForest: aForest
{
  forest = aForest;
  return self;
}

- setFreqLStrikes: (int)freq
{
  freqLStrikes = freq;
  return self;
}

- (void)step
{
  int i,rX,rY;
  int numStrikes;
  id aTree;
  
  //  numStrikes = [uniformRandom rMax: freqLStrikes];
  numStrikes = [uniformIntRand getIntegerWithMin: 0 withMax: freqLStrikes];
  for (i = 0; i < numStrikes; i++)
    {
      //    rX = [uniformRandom rMax: worldSize];
      //    rY = [uniformRandom rMax: worldSize];
      rX = [uniformIntRand getIntegerWithMin: 0 withMax: worldSize - 1];
      rY = [uniformIntRand getIntegerWithMin: 0 withMax: worldSize - 1];
      if ((aTree = [forest treeAtX: rX Y: rY]))
        [aTree burn];
    }
  
  //  return self;
}

@end


