#define __USE_FIXED_PROTOTYPES__  // for gcc headers
#import <misc.h>
#import <space.h>
#import "ForestModelSwarm.h"
#import "YoungForest.h"
#import "MatureForest.h"
#import "SeedSpace.h"
#import "Tree.h"
#import "Species.h"

@implementation Species

+createBegin: aZone {
  Species * obj ;

  obj = [super createBegin: aZone] ;
  obj->initialPopulation = 100 ;
  obj->showAgeLevel = 0 ;

  return obj ;
}

-showSpecies {
  showAgeLevel = 0 ;
  return self ;
}

-showAgeLevel {
  showAgeLevel = 1 ;
  return self ;
}

-setForest: aForest {
  forest = aForest ;
  return self ;
}

-setYoungForest: aYoungForest {
  youngForest = aYoungForest ;
  return self ;
}

-setWorldSize: (int) aSize {
  worldSize = aSize ;
  return self ;
}

-setModelSwarm: aSwarm {
  modelSwarm = aSwarm ;
  return self ;
}

-packArrays {

  ageLevels[0] = ageLevel0 ;
  ageLevels[1] = ageLevel1 ;
  ageLevels[2] = ageLevel2 ;
  ageLevels[3] = ageLevel3 ;
  ageLevels[4] = ageLevel4 ;

  heat[0] = heat0 ;
  heat[1] = heat1 ;  
  heat[2] = heat2 ;

  resistance[0] = resistance0 ;
  resistance[1] = resistance1 ;
  resistance[2] = resistance2 ;

  return self ;
}

-createEnd {
  seedSpace = [SeedSpace createBegin: [self getZone]];
  [seedSpace setSizeX: worldSize Y: worldSize];
  [seedSpace setDeathRate: seedMortalityRate];
  seedSpace = [seedSpace createEnd];
  numberOfTrees = 0 ;
  return self ;
}

-(int) ageOrSpecies {
  return showAgeLevel ;
}

-(char *) getSpeciesName {
  return speciesName ;
}

-(char *) getColorName {
  return colorName ;
}

-setColorMapEntry: (int) aColor {
  color = aColor ;
  return self ;
}

-(int) getInitialPopulation {
  return initialPopulation ;
}

-getSeedSpace {
  return seedSpace ;
}

-(int) getCanopyStructure {
  return canopyStructure ;
}

-(int) getAgeLevel: (int) anAgeLevel {
  return ageLevels[anAgeLevel] ;
}

-(int) getSeedPeriodicity {
  return seedPeriodicity ;
}

-(int) getLevelAtAge: (int) theAge {
  int i ;

  for(i = 0 ; i < 5 ; i++)
    if(theAge <= ageLevels[i])
      break ;

  if( i == 5 ){
    printf("Major problem with step/age/ageLevel mechanism!!!\n") ;
    exit(-1) ;
  }

  return i ;
}

-(int) getHeatAtAge: (int) theAge {
  int i ;

  for(i = 2 ; i < 5 ; i++)
    if(theAge <= ageLevels[i])
      break ;

  if( i == 5 ){
    printf("Major problem with step/age/ageLevel mechanism!!!\n") ;
    exit(-1) ;
  }

  i -= 2 ;

  return heat[i] ;
}

-(int) getPotencyAtX: (int) theX Y: (int) theY {
  Tree * aTree ;
  int numSeeds ;

  numSeeds = [seedSpace seedsAtX: theX Y: theY] ;
  if(numSeeds){
    aTree = [forest treeAtX: theX Y: theY] ;
    if(aTree)
      if( ((Species *)(aTree->species))->canopyStructure > shadeTolerance)
        return 0 ;
  }
  return numSeeds ;
}

-incrementPopulation{
  numberOfTrees++ ;
  return self ;
}

-setTotalNumberOfTrees: (int) aTotal {
  totalNumberOfTrees = aTotal ;
  return self ;
}

- (unsigned)getCount
{
  return numberOfTrees;
}

-(int) stillActive {
  if(numberOfTrees)
    return 1 ;
  else 
    return 0 ;
}

-(double) getRelativeProportion {
  return ((double) numberOfTrees) / ((double) totalNumberOfTrees) ;
}

-(int) getColor {
  return color ;
}

-seed: aTree {
  int i,j,x,y ;
  int seedingCounter ;

  x = ((Tree *) aTree)->x ;
  y = ((Tree *) aTree)->y ;

  seedingCounter = ++( ((Tree *) aTree)->seedingCounter ) ;
  
  if(seedingCounter == seedPeriodicity){
    for(i = x - seedingRadius ; i <= x + seedingRadius ; i++)
      for(j = y - seedingRadius ; j <= y + seedingRadius  ; j++)
        if( (i >= 0) && (j >= 0) && (i < worldSize) && (j < worldSize) )
          [seedSpace addSeeds: seedsPerSquare X: i Y: j] ;

    ((Tree *) aTree)->seedingCounter = 0 ;
  }

  return self ;
}

-step: aTree {
  int age ;

  age = ((Tree *)aTree)->age ;

  if(age == ageLevels[1])
    [youngForest graduateTree: aTree] ;

  if( (age > ageLevels[2]) && (age <= ageLevels[3]) )
    [self seed: aTree] ;
    
  if(age == ageLevels[4]){
    [forest diedTree: aTree] ;
    numberOfTrees -= 1 ;
    return self ;
  }

  //default action...
  ((Tree *)aTree)->age++ ;

  return self;
}

-fireAtX: (int) theX Y: (int) theY theTree: aTree {
  int i,j ;
  id anObj ;
  int generatedHeat ;

  generatedHeat = [self getHeatAtAge: [aTree getAge]] ;

  [youngForest fireAtX: theX Y: theY] ;
  [forest fireAtX: theX Y: theY] ;

  numberOfTrees -= 1 ;

  [modelSwarm fireAtX: theX Y: theY] ;

  for(i = theX - 1 ; i < theX + 2 ; i++)
    for(j = theY - 1 ; j < theY + 2 ; j++)
      if( (i >= 0) && (j >= 0) && (i < worldSize) && (j < worldSize) )
        if( (anObj = [forest treeAtX: i Y: j]) )
          [anObj fireWithHeat: generatedHeat] ;

  return self ;
}

-(int) igniteWithHeat: (int) theHeat AtAge: (int) theAge {
  int i ;

  for(i = 2 ; i < 5 ; i++)
    if(theAge <= ageLevels[i])
      break ;

  if( i == 5 ){
    printf("Major problem with step/age/ageLevel mechanism!!!\n") ;
    exit(-1) ;
  }
 
  i -= 2 ;

  if(theHeat > resistance[i])
    return 1 ;
  else
    return 0 ;
}

-destroySeedsAtX: (int) theX Y: (int) theY {
  [seedSpace putValue: 0 atX: theX Y: theY] ;
  return self ;
}

@end
