#import <random.h>
#import <space.h>
#import "Ball.h"

@implementation Ball

+ create: aZone
{
  return [super create: aZone];
}

- (void) setX: (unsigned) X Y: (unsigned) Y
{
  x = X;
  y = Y;
}

- setWorld: aWorld 
{ 
  world = aWorld;
  [world putObject: self atX: x Y:y];
  return self;
}

- (void) step
{
  id pos1Object, pos2Object;

  pos1Object = [world getObjectAtX: x Y: y+1];
  if (pos1Object == nil)
  {
    [world putObject: nil atX: x Y: y];
    [world putObject: self atX: x Y: ++y];
        return;
  }
  
  pos1Object = [world getObjectAtX: x-1 Y: y+1];
  pos2Object = [world getObjectAtX: x+1 Y: y+1];
  
  if (pos1Object && pos2Object) return;

  [world putObject: nil atX: x Y: y];
  if (pos1Object)
    [world putObject: self atX: ++x Y: ++y];
  else if (pos2Object)
    [world putObject: self atX: --x Y: ++y];
  else
    if ([uniformIntRand getIntegerWithMin: 0 withMax: 1])
      [world putObject: self atX: --x Y: ++y];
        else
      [world putObject: self atX: ++x Y: ++y];
}
- drawSelfOn: (id <Raster>) aRaster
{
  static id ballPixmap;
  
  if (ballPixmap == nil)
  {
    ballPixmap = [Pixmap createBegin: [self getZone]];
      
    [ballPixmap setDirectory: [arguments getAppDataPath]];
    [ballPixmap setFile: "ball.png"];
    ballPixmap = [ballPixmap createEnd];
    [ballPixmap setRaster: aRaster];
  }
  
  [aRaster draw: ballPixmap X: x Y: y];

  return self;
}

@end
