// Bug.m					SimpleBug

#import <space.h>
#import <random.h>
#import "Bug.h"

@implementation Bug

- setWorld: w andList: l {
  
  // Method to put bug into a world
  // If he already is in a world calls
  // the old world (both Grid2d and List)
  // and removes before moving to the new digs
  
  if(world!=nil) {
     [world putObject: nil atX: xPos Y: yPos];
     [w putObject: self atX: xPos Y: yPos];
  }

  world=w;
  worldSize=[world getSizeX];

  if(list!=nil) {
    [list remove: self];
    [l addLast: self];
  }
  list=l;
  
  return self;
}


- setBugColor: (int) c {

  myColor=c;

  return self;
}

- createEnd
{
   [super createEnd];

   return self;
}

- setX: (int)x Y: (int)y
{
  xPos = x;
  yPos = y;

  return self;
}

- step
{
  int newX, newY;

  
  // Method to wander around aimlessly. Bug only moves with
  // 10% probability, put this in to slow down the display
  if([uniformDblRand getDoubleWithMin: 0.0 withMax: 1.0] > 0.1)
    return self;
     
  newX = xPos + [uniformIntRand getIntegerWithMin: -1 withMax: 1];
  newY = yPos + [uniformIntRand getIntegerWithMin: -1 withMax: 1];

  newX = (newX + worldSize) % worldSize;
  newY = (newY + worldSize) % worldSize;

  // Check if new position is taken and move there if not
  if ([world getObjectAtX: newX Y: newY] == nil)
    {
      [world putObject: nil atX: xPos Y: yPos];
      xPos = newX;
      yPos = newY;
      [world putObject: self atX: xPos Y: yPos];
    }
  
  return self;
}

- drawSelfOn: (id <Raster>)r
{
  [r drawPointX: xPos Y: yPos Color: myColor];
  return self;
}
  
@end

