// By BenediktStefansson 1997
// Portions (C) Santa Fe Institute

// Object that ranks other objects according to some
// criterion and returns best objects as individuals or lists

#import "RankedList.h"

@implementation RankedList

-setCollection: (id) c {
	theCollection=c;
	return self;
}

-setProbedSelector: (SEL) s {
	theSelector=s;
	return self;
}

-setReverseRank {
  reverseRank=1;
  return self;
}

-createEnd {
	theList=[Map create:[self getZone]];
	return self;
}


-update {
	id anIndex;
	id aMember;
	id aGroup;
	id theData;

	if(!theProbe) {
		theProbe=[MessageProbe createBegin: [self getZone]];
		[theProbe setProbedSelector: theSelector];
		theProbe=[theProbe createEnd];
	}
	
	anIndex=[theList begin:[self getZone]];
	while((aMember=[anIndex next])) 
	  [aMember removeAll];
	[anIndex drop];
	
	[theList forEach:M(drop)];
	[theList removeAll];
	
	anIndex=[theCollection begin:[self getZone]];

	while((aMember=[anIndex next])) {
	        theData=[RankedData create: [self getZone]];
		[theData setData: (double)[theProbe doubleDynamicCallOn: aMember]];
		if((reverseRank==1))
		  [theData setReverse];
	
                if((aGroup=[theList at: theData])){
                        [aGroup addLast: aMember];
                }
                else {
                        aGroup=[List create: [self getZone]];
			[aGroup addLast: aMember];
                        [theList at: theData insert: aGroup];
                }
        }
     	[anIndex drop];

	return self;
}



-getBest {
	if([theList getCount])
		return [theList getFirst];
	else
		return nil;
}	


-getList {
	return theList;
}

	 
@end

@implementation RankedData 

-setData: (double) d {
  data=d;
  return self;
}

-setReverse {
  reverse=1;
  return self;
}

-(double) getData {
  return data;
}


-(int) compare: o {
  
  int compare;

  if(([o getData]==data)){
    compare=0;
  }
  else {
    if((reverse==1)) {
      if(([o getData]<data))
	compare=1;
      if(([o getData]>data))
	compare=-1;
    } else {
      if(([o getData]<data))
	compare=-1;
      if(([o getData]>data))
	compare=1;
    }
  }
  
  return compare;
}

@end
