// ObserverSwarm.m

#import <objectbase.h>
#import <space.h>
#import <simtoolsgui.h>
#import "ObserverSwarm.h"

@implementation ObserverSwarm

+ createBegin: aZone
{
  ObserverSwarm *obj;
  id <ProbeMap> probeMap;

  obj = [super createBegin: aZone];

  obj->startRed=2;
  obj->startGreen=1;
  obj->startBlue=3;
  

  // Also, build a customized probe map. Without a probe map, the default
  // is to show all variables and messages. Here we choose to
  // customize the appearance of the probe, give a nicer interface.

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // Add in a bunch of variables, one per simulation parameters

  [probeMap addProbe: [probeLibrary getProbeForVariable: "startRed"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "startGreen"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "startBlue"
                                    inClass: [self class]]];
 
  
  // Now install our custom probeMap into the probeLibrary.

  [probeLibrary setProbeMap: probeMap For: [self class]];


  return obj;
}

- createEnd
{
 
  return [super createEnd];
}

- buildObjects
{
  [super buildObjects];
  CREATE_PROBE_DISPLAY (self);
  [controlPanel setStateStopped];


  // A colormap that associates integer numbers with named colors
  colorMap = [Colormap create: self];
  [colorMap setColor: 0 ToName: "grey"];
  [colorMap setColor: 1 ToName: "red"];
  [colorMap setColor: 2 ToName: "green"];
  [colorMap setColor: 3 ToName: "NavyBlue"];

  // Next, create a 2d window for display, set its size, zoom factor, title.
  baseRaster=[ZoomRaster create: self];
  [baseRaster setColormap: colorMap];
  [baseRaster setWidth: 10
                 Height: 10];
  [baseRaster setZoomFactor: 50];
  [baseRaster setWindowTitle: "Scheduledemo"];
  [baseRaster pack];                             // draw the window.
  
  SET_WINDOW_GEOMETRY_RECORD_NAME(baseRaster);
 
   return self;
}

- buildActions
{

  // Create the actions necessary for the simulation. 
  [super buildActions];

  // Many schedules here

  // The first schedule drives the raster itself and the tkEvents
  displaySchedule = [Schedule createBegin: self];
  [displaySchedule setRepeatInterval: 1]; // note frequency!
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createActionTo: actionCache message: M(doTkEvents)];
  [displaySchedule at: 0 createActionTo: baseRaster message: M(drawSelf)];

  // The second schedule will draw a grey pixel
  // on the first line of the raster, one pixel per timestep 
  baseSchedule=[Schedule createBegin: self];
  [baseSchedule setRepeatInterval: 1];
  baseSchedule = [baseSchedule createEnd];
  [baseSchedule at: 0 createActionTo: self message: M(moveBase)];

  // The second schedule will paint four blue pixels at four timesteps
  blueSchedule=[Schedule createBegin: self];
  [blueSchedule setRelativeTime: 1];
  blueSchedule = [blueSchedule createEnd];
  [blueSchedule at: 0 createActionTo: self message: M(moveBlue)];
  [blueSchedule at: 1 createActionTo: self message: M(moveBlue)];
  [blueSchedule at: 2 createActionTo: self message: M(moveBlue)];
  [blueSchedule at: 3 createActionTo: self message: M(moveBlue)];

  // The third schedule will paint one red pixel at a given interval
  redSchedule=[Schedule createBegin: self];
  [redSchedule setRepeatInterval: startRed];
  redSchedule = [redSchedule createEnd];
  [redSchedule at: 0 createActionTo: self message: M(moveRed)];

  // And the fourth schedule will paint green pixels every timestep
  greenSchedule=[Schedule createBegin: self];
  [greenSchedule setRepeatInterval: 1];
  greenSchedule = [greenSchedule createEnd];
  [greenSchedule at: 0 createActionTo: self message: M(moveGreen)];
 
  // Now we show how activation times affect the execution of these schedules
  activateSchedule=[Schedule createBegin: self];
  activateSchedule=[activateSchedule createEnd];
  [activateSchedule at: 0 createActionTo: baseSchedule       message: M(activateIn:): self];
  [activateSchedule at: startGreen createActionTo: greenSchedule   message: M(activateIn:): self]; 
  [activateSchedule at: startBlue  createActionTo: blueSchedule    message: M(activateIn:): self];
  [activateSchedule at: startRed   createActionTo: redSchedule     message: M(activateIn:): self];
  [activateSchedule at: 0 createActionTo: displaySchedule message: M(activateIn:): self];

  return self;
}

- activateIn: swarmContext
{
// activateIn: - activate the schedules so they're ready to run.

  [super activateIn: swarmContext];

  // Now activate our schedule in ourselves. This arranges for the
  // execution of the schedule we built.

  [activateSchedule activateIn: self];

  redPos=startRed;
  greenPos=startGreen;
  bluePos=startBlue;
  basePos=0;
  // Activate returns the swarm activity - the thing that's ready to run.

  return [self getSwarmActivity];
}


// These methods are associated with the schedules and should be
// fairly transparent; the position and color only changes 

-moveBase {

  [baseRaster drawPointX: basePos Y: 0 Color: 0];
  basePos++;

  return self;
}

-moveRed {


  [baseRaster drawPointX: redPos Y: 2 Color: 1];
  redPos+=startRed;
  
  return self;
}


-moveGreen {
  
  [baseRaster drawPointX: greenPos Y: 3 Color: 2];
  greenPos++;

  return self;
}

-moveBlue {
  
  [baseRaster drawPointX: bluePos Y: 1 Color: 3];  
  bluePos++;
  
  return self;
}



@end








