#import <math.h>
#import <graph.h>
#import <booleannet.h>
#import <random.h>
#import <activity.h>
#import <collections.h>
#import <simtoolsgui.h>

#import "BoolNetModelSwarm.h"

@implementation BoolNetModelSwarm

+ createBegin: aZone
{
  BoolNetModelSwarm *obj;
  id <ProbeMap> probeMap;

  obj = [super createBegin: aZone];

  obj->numElements = 50;
  obj->numConnections = 2;
  obj->randSeedFunction = 911;
  obj->randSeedConnect = 411;
  obj->randSeedLayout = 945;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "numElements"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "numConnections"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "randSeedFunction"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "randSeedConnect"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "randSeedLayout"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForMessage: "showNet"
				    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForMessage: "hideNet"
				    inClass: [self class]]]; 
  [probeMap addProbe: [probeLibrary getProbeForMessage: "redistributeInCircle"
				    inClass: [self class]]];
  
  [probeLibrary setProbeMap: probeMap For: [self class]];

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [BoolNode class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "getBoolState"
				       inClass: [BoolNode class]]];  
  [probeMap addProbe: [probeLibrary getProbeForMessage: "setBoolState:"
  				       inClass: [BoolNode class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "getBoolFunc"
				    inClass: [BoolNode class]]];  
  [probeMap addProbe: [probeLibrary getProbeForMessage: "setBoolFunc:"
				    inClass: [BoolNode class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "getNumInputs"
				    inClass: [BoolNode class]]];    
  [probeMap addProbe: [probeLibrary getProbeForVariable: "getNumOutputs"
				       inClass: [BoolNode class]]];   
  [probeMap addProbe: [probeLibrary getProbeForMessage: "makeLinkFromWithInt:"
				    inClass: [BoolNode class]]];

  [probeLibrary setProbeMap: probeMap For: [BoolNode class]];

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [DiGraphLink class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "from"
				    inClass: [DiGraphLink class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "to"
				    inClass: [DiGraphLink class]]];

  [probeLibrary setProbeMap: probeMap For: [DiGraphLink class]];
  
  return obj;
}

- setRandSeedFunction: (int)rs
{
  randSeedFunction = rs;
  return self;
}

- (int)getRandSeedFunction
{
  return randSeedFunction;
}

- setRandSeedConnect: (int)rc
{
  randSeedConnect = rc;
  return self;
}

- (int)getRandSeedConnect
{
 return randSeedConnect;
}

- setRandSeedLayout: (int)rl
{
  randSeedLayout = rl;
  return self;
}

- (int)getRandSeedLayout
{
 return randSeedLayout;
}

- createEnd 
{
  return [super createEnd];
}

- getTheBoolNet
{
  return theBoolNet;
}

- getEntityList
{
  return entityList;
}

- getRandomBoolNode
{
  //Assumes constant numElements!!!
  return [entityList atOffset: 
                        [uniformUnsRand getUnsignedWithMin: 0L 
                                        withMax: (numElements - 1)]];
}

- (int)getNumConnections 
{
  return numConnections;
}

- (int)getNumElements 
{
  return numElements;
}

- setGraphCanvas: aCanvas 
{
  graphCanvas = aCanvas;
  return self;
}

- showNet 
{
   id dynamicCanvas;

   if (graphCanvas) 
      fprintf(_obj_xdebug, "Canvas already exists!\n");
   else
     {
       dynamicCanvas = [Canvas createBegin: self];
       dynamicCanvas = [dynamicCanvas createEnd];
       
       [[dynamicCanvas setHeight: 500] setWidth: 500];
       [dynamicCanvas setWindowTitle: "The Boolean network"];
       [dynamicCanvas packFillLeft: YES];
       GUI_UPDATE_IDLE_TASKS();
       
       [self setGraphCanvas: dynamicCanvas];
       [theBoolNet setRandPosSeed: randSeedLayout];
       [theBoolNet showCanvas: dynamicCanvas];
     }
   
   return self;
}

- hideNet
{
   [theBoolNet hideCanvas];
   [graphCanvas drop];
   [self setGraphCanvas: nil];
   return self;
}    

- redistributeInCircle
{
  [theBoolNet redistribute];
  return self;
}

- buildObjects 
{
  int i;
  id randGFunction, randGConnect;
  int list_length, boolFuncMax;
  int boolFunc;          // variable for Boolean function
  id index, entity;
  BOOL boolState;        // variable for Boolean state
  id newNode;
  
  [super buildObjects];

  // build random number generators for node position on Canvas
  // and Boolean functions for nodes

  // for Boolean function
  randGFunction = [PMMLCG1gen createBegin: [self getZone]];
  [randGFunction setStateFromSeed: randSeedFunction];
  randGFunction = [randGFunction createEnd];

  uRandFunction = [UniformIntegerDist createBegin: [self getZone]];
  [uRandFunction setGenerator: randGFunction];
  uRandFunction = [uRandFunction createEnd];  

  // for Boolean connections
  randGConnect = [PMMLCG1gen createBegin: [self getZone]];
  [randGConnect setStateFromSeed: randSeedConnect];
  randGConnect = [randGConnect createEnd];

  uRandConnect = [UniformIntegerDist createBegin: [self getZone]];
  [uRandConnect setGenerator: randGConnect];
  uRandConnect = [uRandConnect createEnd]; 

  // build the Boolean network
  theBoolNet = [BoolNet create: self];

  // create a number of Boolean elements
  for (i = 0; i < numElements; i++){

    boolFuncMax = ldexp(1, ldexp(1, numConnections)) - 1;    
    //  Boolean function range is given by 2^(2^K) - 1

    // for manual assignment if K = 2 then for "AND" boolFunc = 8; 
    // "OR" boolFunc = 14

    boolFunc = [uRandFunction getIntegerWithMin: 0L withMax:
                                  boolFuncMax]; 
    // assign randomly within this range

    if ((i%2) == 0)    // alternate between "ON" and "OFF" states...
      boolState = 0;
    else 
      boolState = 1; 
    // should really set the above randomly with function getCoinToss...

    newNode = [[[[[BoolNode createBegin: self]
                    setEntityId: i]
                   setBoolState: boolState] 
                  setBoolFunc: boolFunc] 
                 createEnd];
    
    [theBoolNet addNode: newNode];
  }

  // only set the Canvas *after* node creation!
  // set the random position layout using specified seed
  [theBoolNet setCanvas: graphCanvas withRandPosSeed: randSeedLayout];
  entityList = [theBoolNet getNodeList];
  
  // randomise the connections
  list_length = [entityList getCount];
  index = [entityList begin: self];
  
  while ((entity = [index next]))
    {
      // create random links for each element
      if (numConnections > 0) 
        for (i = 0; i < numConnections; i++)
          [entity makeLinkFrom: 
                    [entityList atOffset: 
                                  [uRandConnect getIntegerWithMin: 0L 
                                                withMax: (list_length - 1)]]];
    }
  
  [index drop];
  
  return self;
}



- buildActions 
{
  [super buildActions];

  modelActions = [ActionGroup create: self];
  [modelActions createActionForEach: entityList message: M(stepRule)];  
  // apply calculation of new state to each object
  [modelActions createActionForEach: entityList message: M(update)];    
  // then update the state of the network
  
  modelSchedule = [Schedule createBegin: self];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}

- activateIn: swarmContext 
{
  [super activateIn: swarmContext];
  [modelSchedule activateIn: self];

  return [self getSwarmActivity];
}

@end










