// **********************************
// from basic code to apps: keep this file unchanged
// **********************************

// BPCTRuleMaster.h 

#import <objectbase/SwarmObject.h>
#import "BPCTRuleMaker.h"
#import "Matrix.h"
#import "MatrixMult.h"
#import "VectorTransFunc.h"
#import "DataWarehouse.h"

@interface BPCTRuleMaster: SwarmObject
{
   DataWarehouse * agentDataWarehouse;
   Matrix * dataVerificationMatrix, * outputVerificationMatrix,
          * targetVerificationMatrix,
      * wih, * dwih, * who, * dwho;
   int     inputNodeNumber, inputNodeNumber1,
           hiddenNodeNumber, hiddenNodeNumber1, outputNodeNumber,
           patternNumberInVerificationSet;
   Matrix * inputLayer, * hiddenLayer, * outputLayer, * minmax;
   float backPropagationError, proportionalError;
   MatrixMult * matrixMult;
   VectorTransFunc * vectorTransFunc;

   BPCTRuleMaker * ruleMaker;
}

- createEnd;

// tools
- setRuleMaker: rm;
- setMatrixMult: mM;
- setVectorTransFunc: vtf;

// neural network forward step
- applyRulesToInputOutputValuesInDataWarehouseStepA: agentDw;
// neural network learning
- applyRulesToInputOutputValuesInDataWarehouseStepB: agentDw;

// to return error measures
-(float) getBackPropagationErrorInVerificationSet;
-(float) getProportionalErrorInVerificationSet;

-(float) getBackPropagationErrorInTrainingSet;
-(float) getProportionalErrorInTrainingSet;

@end

