// **********************************
// from basic code to apps: keep this file unchanged
// **********************************

// Interface.m                                        

#import "Interface.h"

// This is the basis of each agent interface; the adaptation to each speficic
// agent type are contained exclusively in specific interface objects,
// which inherit from this one (as an example, in the basic code distribution,
// we have SpecificInterface.h and .m)

@implementation Interface

// to find agent data and structure

- setDataWarehouse: dw
{
  myAgentDataWarehouse = dw;
  return self;
}

// in CT case, we can use External Objectives (EO) or External Porposal (EP)
// following a set of "if" instructions that use this variable in the
// specific interfaces

- setUseEO_EP: (int) eo
{
  useEO_EP=eo;
  return self;
}

- setAgentNumber: (int) n
{
  number=n;
  return self;
}

- createEnd
{
  [super createEnd];

  // automatic determination of parameters and matrix addresses via
  // myAgentDataWarehouse

  inputNodeNumber                = [myAgentDataWarehouse
                                    getInputNodeNumber];
  patternNumberInVerificationSet = [myAgentDataWarehouse
                                    getPatternNumberInVerificationSet];
  // array addresses from datawarehouse
  outputVerificationMatrix = [myAgentDataWarehouse
                                              getOutputVerificationMatrix];
  targetVerificationMatrix = [myAgentDataWarehouse
                                              getTargetVerificationMatrix];
  dataVerificationMatrix   = [myAgentDataWarehouse
                                              getDataVerificationMatrix];
  dataTrainingMatrix       = [myAgentDataWarehouse
                                              getDataTrainingMatrix];
  minmax                   = [myAgentDataWarehouse
                                              getMinmax];

  return self;
}

- (int) getAgentNumber
{
  return number;
}


  // the following methods are left intentionally void; they will be
  // overridden in the other XXXInterface objects that we will generate
  // when using the CT scheme or simply an internal automatic input
  // and target generation process as in SpecificInterface.h
  // and SpecificInterface.m in the basic code distribution

  // they are needed here because, to keep Agent.h and Agent.m unchanged,
  // we import, in Agent.h, Interface.h as a type for myInterface, while the
  // agent instance will receive the address of its proper specific
  // interface:
  // if the type Inteface would not respond to the method reported below,
  // we should receive a few warning messages during the compilation


- initialize
{
  return self;
}

- setCT_Inputs
{
  return self;
}

- setCT_Targets
{
  return self;
}

@end
