// Programme dispersion.
// Bruno Cuvelier - ORSTOM.
// Date : 20/01/97.
// Interface de la grille representant la densite des agents.

#import <space.h>

// Type abstrait pour les valeurs de densite
typedef int Density;

extern const Density maxDensity;
extern const Density minDensity;

// Etat de la densite autour d'un agent.
typedef enum { low, high } DensityExtremeType;

@interface DensitySpace : Discrete2d {
  int neighborhood;  // Voisinage de perception des agents
}

// Affectation du parametre de voisinage
-setNeighborhood: (int) value;

// Nouvelle methode : Initialisation de la carte des densite
-incDensityAroundX: (int) x Y: (int) y;
-decDensityAroundX: (int) x Y: (int) y;

// Nouvelle methode : Recherche la cellule voisine ayant la densite de
// population la plus proche de celle recherchee par l'agent en (x,y).

-(Density) findBetterDensity: (DensityExtremeType) type
		      X: (int *) px 
		      Y: (int *) py;

// Renvoie la densite a la position demandee
-(Density) getDensityAtX: (int) x Y: (int) y;

@end
