// Programme dispersion.
// Bruno Cuvelier - ORSTOM.
// Date : 12/02/97.

// Un SpeedSwarm gere un ensemble d'agents qui se dplacent a la meme
// vitesse. Son role est d'ordonnancer l'ensemble des agents qui lui
// sont rataches. Les agents peuvent migrer d'un SpeedSwarm a un autre
// SpeedSwarm lorsque leur vitesse se modifie. Cette migration est
// geree par un MigrationSwarm qui communique aux SpeedSwarm les ordres
// d'ajout (addAgent) et de deletion (removeAgent) des agents.

#import <swarmobject.h>
#import "Agent.h"
#import <activity.h>
#import <collections.h>

@interface SpeedSwarm : Swarm {
  int speedValue;    // Vitesse des agents presents dans le Swarm
  int nbOfAgents;    // Nombre d'agents presents dans le monde

  id modelActions;   // Schedulling des agents
  id modelSchedule;

  id agentList;      // Liste des agents
}

// Methodes permettant la migration des agents entre les Swarms.
-addAgent: anAgent;
-removeAgent: anAgent;

// Methodes de manipulation des agents.
-getAgentList;
-sendNewDensity: (id) density;

// Methodes generales necessaires pour les swarms.
+createBegin: (id) aZone withSpeed: (int) aSpeed;
-createEnd;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

@end

