// Programme dispersion.
// Bruno Cuvelier - ORSTOM.
// Date : 12/02/97.

// Un SpeedSwarm gere un ensemble d'agents qui se dplacent a la meme
// vitesse.

#import "SpeedSwarm.h"

@implementation SpeedSwarm
// Immigration d'un agent
-addAgent: anAgent {
  [agentList addLast: anAgent];

  return self;
}

// Emmigration d'un agent
-removeAgent: anAgent {
  [agentList remove: anAgent];

  return self;
}

// Coloration des agents presents dans le speedSwarm.
-getAgentList {
  return agentList;
}

// Modification de la densite ideale des agents
-sendNewDensity: (id) density {
  int i;

  for (i=0; i<[agentList getCount]; i++)
    [[agentList atOffset: i] setIdealDensity: density];

    //[agentList forEach: M(setIdealDensity) : density];
  return self;
}

// Creation du Swarm : initialisation du Swarm
+createBegin: (id) aZone withSpeed: (int) aSpeed {
  SpeedSwarm *obj;

  obj= [super createBegin: aZone];
  obj->speedValue= aSpeed;
  obj->nbOfAgents= 0;

  return obj;
}

// Creation du Swarm : validation
-createEnd {
  return [super createEnd];
}

// Construction des objets du Swarm
-buildObjects {
  // Creation de la liste qui contiendra les agents 
  agentList= [List create: [self getZone]];

  return self;
}

//Creation du Scheduler charge de l'ordonnancement des agents.
-buildActions {
  [super buildActions];
  
  // Creation du plan d'action. 
  modelActions= [ActionGroup create: [self getZone]];

  // Definition des actions.
  // Pour chaque agent du Swarm activer la methode qui code
  // son comportement (step).
  [modelActions createActionForEach: agentList message: M(step)];

  // Creation du scheduler.
  // Le scheduler a pour objectif de gerer l'execution du plan
  // d'actions (ActionGroup) dans le temps. Sans le scheduler
  // le plan d'action ne peut pas etre active.
  modelSchedule= [Schedule createBegin: [self getZone]];
  
  // Le scheduler execute le plan d'action en fonction de sa vitesse.
  [modelSchedule setRepeatInterval: speedValue];

  // Creation du Scheduler : validation
  modelSchedule= [modelSchedule createEnd];

  // A l'instant 0 le groupe d'actions "modelActions" est active.
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}

// Activation du scheduling du speedSwarm.
-activateIn: (id) swarmContext {

  // Activation du speedSwarm lui-meme par l'intermediaire de la superclasse.
  [super activateIn: swarmContext];

  // Activation du scheduler du speedSwarm.
  [modelSchedule activateIn: self];

  // renvoie sa propre activite.
  return [self getSwarmActivity];
}

@end
