#import "grid.h"
#import <activity.h>

#define __USE_FIXED_PROTOTYPES__   // for gcc headers
#include <stdio.h>

static BOOL trace( id anActivity );

int main(void)
{
  id   aZone, aList, aTurtle;
  id   emptyActions, moveActions, printActions, moveAndPrint;
  id   groupActivity, swarm, swarmActivity, status;
  int  i, stepCount;

  initModule( grid );
  initModule( activity );

  aZone = [Zone create: globalZone];
  swarm = [SwarmProcess create: aZone];
  _activity_zone = [Zone create: globalZone];

  [_activity_zone xprint];
  swarmActivity = [swarm activateIn: nil];
  [swarmActivity drop];
  [_activity_zone xprint];

  //  if ( _obj_debug ) exit(0);

  aList = [List create: swarm];

  for ( i = 0; i < 10; i++ ) {
    aTurtle = [GridTurtle create: swarm];
    [aTurtle turn: -1];
    [aTurtle move: i * 10];
    [aTurtle turn: 1];
    [aList addLast: aTurtle];
  }

  emptyActions = [ActionGroup create: swarm];

  moveActions = [ActionGroup create: swarm];
  for ( i = 0; i < 10; i++ ) {
    if ( i % 2 )
      [moveActions
        createActionTo: [aList atOffset: i] message: M(move:) : (id)10 ];
  }

  printActions = [ActionGroup create: swarm];
  for ( i = 0; i < 10; i++ ) {
    [printActions createActionTo: [aList atOffset: i] message: M(print)];
  }

  moveAndPrint = [ActionGroup create: swarm];
  [moveAndPrint createAction: emptyActions];
  [moveAndPrint createAction: moveActions];
  [moveAndPrint createAction: printActions];
  for ( i = 0; i < 10; i++ ) {
    if ( i % 2 )
      [moveAndPrint
        createActionTo: [aList atOffset: i] message: M(move:) : (id)10];
  }
  [moveAndPrint createActionForEach: aList message: M(print)];

  groupActivity = [moveAndPrint activateIn: nil];
  printf("about to start schedule\n");
  while ( (status = [groupActivity run]) != Completed );
  printf( "run return status: %s\n\n", [status getName] );
  [groupActivity drop];

  swarmActivity = [swarm activateIn: nil];
  [swarm activate: moveAndPrint];

  if ( swarmActivity != [swarm getSwarmActivity] )
    raiseEvent( WarningMessage, nil );

  _activity_trace = trace;

  for ( stepCount = 1; [swarmActivity step] == Stopped; stepCount++ );
  printf( "number of steps: %d\n", stepCount );

  [swarmActivity drop];
  [_activity_zone xprint];

  [emptyActions drop];
  [moveActions drop];
  [printActions drop];
  [moveAndPrint drop];
  [aList deleteAll];
  [aList drop];
  [[swarm getInternalZone] xprint];

  [swarm drop];
  [aZone xprint];
  return 0;
}

static BOOL trace( id anActivity )
{
  char  buffer[100];

  if ( getCurrentAction() ) {
    _obj_formatIDString( buffer, getCurrentAction() );
    printf( "action trace: %s\n", buffer );
  } else {
    printf( "action trace: activity status %s\n",
      [[anActivity getStatus] getName] );
  }
  return 0;
}
