// "MySwarmAppArguments.m"
// Subclass of Arguments, to accommodate Drone command line arguments
// Sven Thommesen <sthomme@humsci.auburn.edu> 1998-08-27

// This implementation assumes that you already have code in your app to
// parse Drone's command line arguments; you just need for Swarm's 
// Argument to leave them alone and not croak.

// In Drone's drone.params, you need to do
//   param setParamOption = " -D "
// to work with this file.
// Other arguments must also be of the sort "-D <arg>=<value>"
// (notice the SPACE after -D).

#import "MySwarmAppArguments.h"

@implementation MySwarmAppArguments

+ createBegin: aZone
{
  static struct argp_option options[] = {
    {"protocol",    'p', "PROTOCOL", 0, "Set protocol",         5},
    {"drone-param", 'D',    "PARAM", 0, "Parameter from Drone", 6},
    { 0 }
  };
  
  MySwarmAppArguments *obj = [super createBegin: aZone];

  [obj addOptions: options];
  return obj;
}

- (int)parseKey: (int)key arg: (const char *)arg
{
  if (key == 'p')
    {
      protocolArg = arg;
      return 0;
    }
  else if (key == 'D')
    {
      droneArg = arg;
      return 0;
    }
  else
    return [super parseKey: key arg: arg];
}

- (const char *)getProtocolArg
{
  return protocolArg;
}

- (const char *)getDroneArg
{
  return droneArg;
}

@end
