// Agent.h 

#import <objectbase.h>
#import <objectbase/SwarmObject.h>
#import <space.h>
#import <gui.h>                    
#import "MoGrid2d.h"    // we use Sven Thommesen class to allow
                        // multiple occupancy in a grid

#import "RuleManager.h"  // the source of the rules determining agent behavior


@interface Agent: SwarmObject
{
  int xPos, yPos, Dx, Dy;
  int worldXSize, worldYSize;
  int manyAgentsInASquare;  // if = 1 multiple occupancy is allowed

  id ruleManager;
  MoGrid2d * world;
  id traces;

}

- setWorld: w Traces: tr agentsInASquare: (int) ag;
- setRuleManager: rp;
- createEnd;

- setX: (int) x Y: (int) y;
- setFirstStepDx: (int) dx Dy: (int) dy;
- step;

- drawSelfOn: (id <Raster>)r;

@end

