// ModelSwarm.m 

#import "ModelSwarm.h"
#import <random.h>
#import <activity.h>
#import <collections.h>
#import "MoGrid2d.h"

@implementation ModelSwarm  

// These methods provide access to the objects inside the ModelSwarm.
// These objects are the ones visible to other classes via message call.
// In theory we could just let other objects use Probes to read our state,
// but message access is frequently more convenient.

- getAgentList
{
  return agentList;
}

- getWorld
{
  return world;
}

- getTraces
{
  return traces;
}

+ createBegin: aZone 
{
  ModelSwarm *obj;
  id <ProbeMap> probeMap;

  // in createBegin, we set up the simulation parameters

  // First, call our superclass createBegin - the return value is the
  // allocated Swarm object.

  obj = [super createBegin: aZone];

  // Now fill in various simulation parameters with default values.

  obj->worldXSize          = 200;
  obj->worldYSize          = 200;
  obj->exAnteTraceProb     = 0.01;
  obj->agentNumber         = 10;
  obj->manyAgentsInASquare = 0; // 0=no; 1=yes

  // Build a customized probe map. Without a probe map, the default
  // is to show all variables and messages. Here we choose to
  // customize the appearance of the probe, give a nicer interface.

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // Add in a bunch of variables, one per simulation parameter

  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldXSize"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "worldYSize"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "exAnteTraceProb"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "agentNumber"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: "manyAgentsInASquare"
                                    inClass: [self class]]];

  // Now install our custom probeMap into the probeLibrary.

  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  // We've created the Langton Ant simulator and initialized it.
  // return the id of the newly created Swarm

  return obj;
}

- createEnd
{
  return [super createEnd];
}

- buildObjects
{
  Agent *anAgent;
  int x, y, i, k;

  // Here, we create the objects in the model
  
  // Here we craete and instance of RuleManager
  //  (one or more, in complex apps.)
  ruleManager = [RuleManager createBegin: self];
  ruleManager = [ruleManager createEnd];

  // Then, create the food space and initialize it

  traces = [TraceSpace createBegin: self];
  [traces setSizeX: worldXSize Y: worldYSize];
  traces = [traces createEnd];
  
  [traces seedTraceWithProb: exAnteTraceProb]; // ex ante traces

  // Now set up the grid used to represent agent position

  world = [MoGrid2d create: self setSizeX: worldXSize Y: worldYSize];

  // Now, create a bunch of agents (Langton Ants) to live in the world

  agentList = [List create: self];

  for (i=1;i<=agentNumber;i++){

   x = [uniformIntRand getIntegerWithMin: 0 withMax: worldXSize];
   y = [uniformIntRand getIntegerWithMin: 0 withMax: worldYSize];
          anAgent = [Agent createBegin: self];
          [anAgent setWorld: world Traces: traces
                             agentsInASquare: manyAgentsInASquare];
          [anAgent setRuleManager: ruleManager];
          anAgent = [anAgent createEnd];
          [anAgent setX: x Y: y];

   // fist step direction (N,E,S,W)
   k = [uniformIntRand getIntegerWithMin: 1 withMax: 4];       
   if (k == 1) [anAgent setFirstStepDx:  0 Dy:  1]; // N
   if (k == 2) [anAgent setFirstStepDx: -1 Dy:  0]; // E
   if (k == 3) [anAgent setFirstStepDx:  0 Dy: -1]; // S
   if (k == 4) [anAgent setFirstStepDx:  1 Dy:  0]; // W

          [agentList addLast: anAgent];
   }
  
  return self;
}

- buildActions
{
  // Create the list of simulation actions. We put these in an action
  // group, because we want these actions to be executed in a specific
  // order, but these steps should take no (simulated) time. The
  // M(foo) means "The message called <foo>". You can send a message
  // To a particular object, or ForEach object in a collection.

  modelActions = [ActionGroup create: self];
  [modelActions createActionForEach: agentList    message: M(step)];

  // Then we create a schedule that executes the modelActions. modelActions
  // is an ActionGroup, by itself it has no notion of time. In order to
  // have it executed in time, we create a Schedule that says to use
  // the modelActions ActionGroup at particular times.
  // This schedule has a repeat interval of 1, it will loop every time step.
  // The action is executed at time 0 relative to the beginning of the loop.

  // This is a simple schedule, with only one action that is just
  // repeated every time. See mousetraps for more complicated schedules.

  modelSchedule = [Schedule createBegin: self];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions]; 

  return self;
}

- activateIn: swarmContext
{
  // Here, we activate the swarm in the context passed in
  // Then we activate our schedule in ourselves

  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];

  return [self getSwarmActivity];
}

@end
