// Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <stdlib.h>
#import "LLAMJ_Ca2d.h"
#import "LLAMJ_ModelSwarm.h"

@implementation LLAMJ_Ca2d

-(int)getDensity {return density;}

+createBegin: aZone setModelSwarm: s setDisplayWidget: d {
LLAMJ_Ca2d *ca;

  ca = [super createBegin: aZone];
  ca->modelSwarm = s;
  ca->displayWidget = d;
  return ca;

}

-updateDisplayWidget {
int size, i, j;

  size = [modelSwarm getGridSize];
  for(i=0; i<size; i++){
    for(j=0; j<size; j++){
      [displayWidget drawPointX: i Y: j Color: [self getValueAtX: i Y: j]];
    }
  }
  return nil;
}


-initializeLattice {
int size, i, j;

  size = [modelSwarm getGridSize];
  for(i=0; i<size; i++){
    for(j=0; j<size; j++){
      [self putValue: 0 atX: i Y: j];
    }
  }
  [self putValue: 1 atX: (size/2) Y: (size/2)];
  [self putValue: 1 atX: (size/2)-1 Y: (size/2)];
  [self putValue: 1 atX: (size/2)-2 Y: (size/2)];
  [self putValue: 1 atX: (size/2) Y: (size/2)-1];
  [self putValue: 1 atX: (size/2)-1 Y: (size/2)-2];
  [self updateLattice];
  [self updateDisplayWidget];
  [displayWidget drawSelf];
  return nil;
}

-stepRule {
int size, i, j, k, a, b, old, sum, el, eu, birth;

  k = [modelSwarm getK];
  size = [modelSwarm getGridSize];
  el = [modelSwarm getEl];
  eu = [modelSwarm getEu];
  birth = [modelSwarm getBirth];
  
  density = 0;

  for(i=k; i<size-k; i++){
    for(j=k; j<size-k; j++){

      sum = 0.0;
      for(a=(i-k); a<=(i+k); a++){
        for(b=(j-k); b<=(j+k); b++){
	  sum += [self getValueAtX: a Y: b];
	}
      }

      old = [self getValueAtX: i Y: j];
      if ((old == 1) && (sum < eu) && (sum > el)){
	[self putValue: 1 atX: i Y: j];
      } else if ((old == 0) && (sum == birth)){
	[self putValue: 1 atX: i Y: j];
      } else {
        [self putValue: 0 atX: i Y: j];
      }

      if ([self getValueAtX: i Y: j] == 1){
	density++;
      }

    }
  }

  [self updateLattice];
  [self updateDisplayWidget];

  return nil;
}

@end
