#import "RMemLogger.h"
#import "MemLogClassData.h"
#import "Hashtable.h"

@implementation RMemLogger

+create: aZone fileName: (const char*) fname
{
	RMemLogger *obj;
	FILE *fp;

	obj = [RMemLogger createBegin: aZone];
	
	if (fname)
		fp = fopen (fname, "w");
	else fp = stdout;
	[obj setOutputStream: [OutputStream create: aZone setFileStream: fp]];

	return [obj createEnd];
}

+ createBegin: aZone
{
	RMemLogger *obj;
	
	obj = [super createBegin: aZone];
	
	obj->myStream = nil;
	obj->myObjects = [[Hashtable alloc] initKeyDesc:"*" valueDesc:"i"];
	obj->isCumulative = NO;
	obj->lastTime = -1;

	return obj;
}

- (void) setCumulative
{
	isCumulative = YES;  // should lead to subclass/subprotocol later
}

- (void)setFilename: (char*) fname
{
	FILE *fp;

	if (fname)
		fp = fopen (fname, "w");
	else fp = stdout;

	myStream = [OutputStream create: [self getZone] setFileStream: fp];
}

- (void)setOutputStream: aStream
{
	myStream = aStream;
}

- createEnd
{
	if (myStream == nil)
	{
		myStream = [OutputStream createBegin: [self getZone]];
		[myStream setFileStream: stdout];
		myStream = [myStream createEnd];
	}

	if (isCumulative)
		[myStream catC: "   Step  Class  Memory\n"];
	else
		[myStream catC: "   Step  Create/Drop  Class  Number  Memory\n"];

	return [super createEnd];
}

//---------------------------------------------------

- (void)consumeRecordTime: (timeval_t) aTime alloc: (int) i
    className: (const char*) cname address: (void*) addr size: (long) size;
{
	char buf[256];

	if (isCumulative)
	{
		if (aTime != lastTime)
		{
			GNUHashState state;
			char *akey;
			MemLogClassData* val;

			state = [myObjects initState];
			while ([myObjects nextState: &state 
					key: (const void**)&akey 
					value: (void**)&val])
			{
				int n = [val getN];
				if (!n) continue;
				sprintf (buf, "%ld %s %d %ld\n",
					aTime,
					akey,
					n,
					[val getSize]*n);
				
				[myStream catC: buf];
			}
		
			lastTime = aTime;
		}
		
		if ([myObjects isKey: cname])
		{
			MemLogClassData *data = [myObjects valueForKey: cname];
			int n = [data getN];
			if (i == YES) ++n;
			else          --n;
			[data setN: n];
		}
		else
			[myObjects insertKey: cname value:
				[MemLogClassData create: [self getZone]
					setN: i?+1:-1 setSize: size]];
	}
	else
	{
		sprintf (buf, "%ld %c %s %ld\n",
			aTime+1,
			i? 'C':'D',
			cname,
			size);
	
		[myStream catC: buf];
	}
}
