// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.


// ObserverSwarm.h

#import "ModelSwarm.h"
#import "MultiScaled2d.h"
#import <analysis.h>         // EZGraph
#import <simtools.h>         // ObjectLoader
#import <objectbase.h>

#define MAX 10000     // my set maximal value at discrete2d
#define MAXNUTRIS 10      // max. number of nutrients
#define MAXFILENAME 100  // max. lenght of simulation name

@interface BatchObserverSwarm: Swarm
{
  int displayFrequency;   
  int experimentDuration;
  int useSetupFile;
  int loadRandSeed;
  int drawPopulGr;      
  int drawNutrisGr;
  int drawNutriFracsGr;
  int drawFreeBiomassGr;
  int drawMagsBiomassGr;
  int drawContribNutriGr;
  int drawMetabGr;
  int drawCyclRatiosGr;
  int drawIOCardStatGr;
  int drawIOEntropyGr;
  int drawOptFracsStatGr;
  int tik;
  unsigned expTime;    // current time steps of experiment

  id displayActions;                          
  id displaySchedule;
  id stopSchedule;

  ModelSwarm *modelSwarm;          	      
  FILE *statusFile;

  id <EZGraph> populationGraph; // all popul + births + deaths
  id <EZGraph> allNutriGraph;
  id <EZGraph> allNutriFracsGraph; // amt of nutritients ratios [%] A,B, ..
  id <EZGraph> freeBiomassGraph;   // amt of free biomass A,B, .. in world
  id <EZGraph> cyclRatiosGraph; // cycling ratios = min(prod,cons)/max(inF,ouF)
  id <EZGraph> magsBiomassGraph;   // nutri stored in Mags
  id <EZGraph> magsContribNutrisGraph;  // nutri in space added/taken by Mags
  id <EZGraph> ioCardStatGraph; // avg and std deviation of in/out nutri cardinality
  id <EZGraph> ioEntropyGraph;     // entropy of Mags' inputs / outputs 
  id <EZGraph> optFracsStatGraph;  // error from optimum nutri fracs. measure
  id <EZGraph> metabGraph;         // metabolisms
}

+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- saveModel;
- stopRunning;
- go;
- activateIn: swarmContext;

@end

