// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// geneticsFloat.h                                    Peter Zvirinsky mar,1999
// Library for implementing genetics in SWARM agents with Float values
//    genome:  binary string
//    gene:    set of bits, type FLO,BITS
//    classes: GeneMap, GeneType				      

#import <objectbase/SwarmObject.h>
#import <collections.h> 
#import <random.h>

//====================================================================
// class Gene, structure for describing type and parameters
// of particular gene
//====================================================================

@interface Gene: SwarmObject
{ 
  char      name[21];
  char      type[5];
  unsigned  start;
  unsigned  len;
  float     min;
  float     max;
}

- setGName:   (char *)name;
- setGType:   (char *)type;
- setGStart:  (unsigned)start;
- setGLength: (unsigned)len;
- setGMin:    (float) min;
- setGMax:    (float) max;
- (char *)   getGName;
- (char *)   getGType;
- (unsigned) getGStart;
- (unsigned) getGLength;
- (float)    getGMin;
- (float)    getGMax;

@end

//====================================================================
// class GeneMap, List of pointers to GeneTypes
//====================================================================


@interface GeneMap: SwarmObject
{
  id geneMap;                     // pointer to List
  id <RandomBitDist> randBit;
  unsigned gMapLength;
}

- createEnd;
- createGeneType: (char *)   type
            Name: (char *)   name
           Start: (unsigned) start
          Length: (unsigned) len
             Min: (float)    min
             Max: (float)    max;
- getGeneWithName: (char *) nam;
- (char *)   getNameOfGene: (unsigned) index;
- (char *)   getTypeOfGene: (char *)nam;
- (unsigned) getStartOfGene: (char *)nam;
- (unsigned) getLengthOfGene: (char *)nam;
- (float)    getMinOfGene: (char *)nam;
- (float)    getMaxOfGene: (char *)nam;
- (unsigned) getGMapLength;

- (char *)   createGenome;
- randInitGenome: (char *) p;
- (char *) cloneGenome: (char *)p1;
- (int) mutateGenome: (char *) p withProb: (float) pmut;
- (float) getValueOfGene: (char *) nam ofGenome: (char *)p;
- setValue: (float) val ofGene: (char *) name ofGenome: (char *)p;
- printGenome: (char *) p;
@end

        



