// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Mag.h				      

#import <objectbase/SwarmObject.h>
#import <space.h>
#import <gui.h>
#import "MultiScaled2d.h"

@interface Mag: SwarmObject
{ 
  int xPos, yPos;     
  int worldSize;
  float magSize;
  float basalMetab;
  float moveMetab;
  float enzMetab;
  float satisfMetab;
  float consRate;
  float D;                     // scaled difference between real and opt. nutriFracs
  int magAge;
  float *KmetabP,*KmoveP,*KconsumP,*KsatisfP,*ExponP,*enzCostP;

  int inputsNum;               // number of Mag inputs (consumed nutris)
  int outputsNum;              // number of Mag outputs (produced nutris)
  //  float *ioTresholdP;            // treshold dividing gene range into: 
                                      // <-1, -ioTr>this nutri type as output
                                      // <-ioTr, +ioTr> as none
                                      // <+ioTr, 1> as input
  float *magNutriFracs;         // array of gene nutri selection genes <-1,1>
  float *optNutris;              // pointer to array in ModelSwarm for faster access
  //  int magInputsNum;             // number of Mag's inputs
  int vision;
  int maxMR;
  char *magGenome;
  float *nutriStocks;              // array of mag's "stomachs" 

  float *nutriUtils;             // local copy of variable for faster execution
  int nutrisNum;                 // local copy of variable for faster execution

  int *enzymes;                  // array of enzyme(A,B,..) flags
  int enzymesNum;                // number of enzymes flags - base for basalMetab rate

  int hasMoved;                 // local flag
 
  id <Grid2d> world;
  
  id nutrisList;
  id modelSwarm;
}

- setWorld: w NutrisList: f;
- createEnd;

- setModelSwarm: s;
- setX: (int)x Y: (int)y;
- setMagSize: (float) Numb;
- setBasalMetab: (float) metab;
//- setMoveMetab: (float) metab;
- setSatisfMetab: (float) metab;
- setConsRate: (float) rate;
- setInputsNum: (int) inp;
- setOutputsNum: (int) outp;
- setVision: (int) vis;
- setMaxMR: (int) vis;
//- setMagInputsNum: (int) n;
- setMagGenome: (char *) genome;
//- setIOTresholdP: (float *) ioTr;
- setNutriFracs: (float *) pointer;
- setNutriStocks: (float *) fs;
- setOptNutris: (float *) fs;
- setEnzymes: (int *) en;
- setEnzymesNum: (int) enNum;
- setStock: (int) i value: (float) val;
- setNutriUtils: (float *) fpointer;
- setHasMoved: (int) i;
- setMagAge: (int) i;
- getX: (int *)x Y: (int *)y;
- (int) getX;
- (int) getY;
- (float) getMagSize;
- (float) getBasalMetab;
- (float) getMoveMetab;
- (float) getEnzMetab;
- (float) getSatisfMetab;
- (float) getTotalMetab;
- (float) getConsRate;
- (float *) getNutriFracs;
- (float) getNutriFracAtIndex: (int) i ;
- (float) getOptNutriAtIndex: (int) i ;
- (int) getVision;
- (int) getMaxMR;
//- (int) getMagInputsNum;
- (char *) getMagGenome;
//- (float *) getMagNutriFracs;
- (float *) getNutriStocks;
- (float) getStock: (int) i;
- (float) getNutriUtil: (int) i;
- (int *) getEnzymes;
- (int) getEnzymesNum;
- (int) getEnzymeAt: (int) i;
- (int) getEnzMag;               // return 0/1 if Mag is or not producing enzymes
- (int) getHasMoved;
- (int) getMagAge;
- (float) getD;
- (float) getNutriValue: (int) i; 
- step;
- drawSelfOn: (id <Raster>)r;

@end


