// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Mag.m				

#import "Mag.h"
#import <random.h>
#include <math.h>
#import "ModelSwarm.h"
#define intabs(a) ((a) < 0 ? -(a) : (a))

@implementation Mag

- setWorld: w NutrisList: f        {  world = w;   nutrisList = f;  return self; }
- setModelSwarm: s                 {  modelSwarm = s;   return self; }
- setMagGenome: (char *) genome    { magGenome = genome; return self; }
//- setIOTresholdP: (float *) ioTr   { ioTresholdP = ioTr; return self; }
- setNutriFracs: (float *) pointer { magNutriFracs = pointer; return self; }
- setNutriStocks: (float *) fs     { nutriStocks = fs;  return self; }
- setOptNutris: (float *) pointer  { optNutris = pointer; return self; }

- setStock: (int) i value: (float) val   { nutriStocks[i] = val; return self; }

- setNutriUtils: (float *) fpointer      { nutriUtils = fpointer; return self; }  

- setEnzymes: (int *) en           { enzymes = en; return self; }
- setEnzymesNum: (int) enNum       { enzymesNum = enNum; return self; }

- setMagAge: (int) i               { magAge = i; return 0; }

- createEnd
{
   [super createEnd];

   worldSize = [world getSizeX];
   nutrisNum = [modelSwarm getNutrisNum];
   KmetabP = [modelSwarm getKmetabP]; 
   KmoveP = [modelSwarm getKmoveP]; 
   KconsumP = [modelSwarm getKconsumP]; 
   KsatisfP = [modelSwarm getKsatisfP]; 
   enzCostP = [modelSwarm getEnzymeCostP]; 
   ExponP = [modelSwarm getExponP]; 
   [self setHasMoved: 0];
   [self setMagAge: 0];
   return self;
}

- setX: (int)x Y: (int)y             { xPos = x;   yPos = y;   return self; }
- setMagSize: (float) size           { magSize = size;   return self; }
- setBasalMetab: (float) m           { basalMetab = m;   return self; }
- setMoveMetab: (float) m            { moveMetab = m;   return self; }
- setSatisfMetab: (float) m          { satisfMetab = m;   return self; }
- setConsRate: (float) cr            { consRate = cr;   return self; }
- setVision: (int) vis               { vision = vis;   return self; }
- setMaxMR: (int) mr                 { maxMR = mr;   return self; }
- setInputsNum: (int) n              { inputsNum = n; return self; }
- setOutputsNum: (int) n             { outputsNum = n; return self; }
- setHasMoved: (int) i               { hasMoved = i; return self; }

- getX: (int *)x Y: (int *)y         { *x = xPos, *y = yPos;  return self; }
- (int) getX            {  return xPos;  }
- (int) getY            {  return yPos;  }

- (float) getMagSize    {  return magSize; }

- (float) getBasalMetab {  return basalMetab; }
- (float) getMoveMetab  {  return moveMetab; }
- (float) getEnzMetab   {  return enzMetab; }
- (float) getSatisfMetab{  return satisfMetab; }
- (float) getTotalMetab {  return basalMetab+moveMetab+enzMetab; }
- (float) getConsRate   {  return consRate ; }

- (float) getNutriFracAtIndex: (int) i  { return magNutriFracs[i]; } 
- (float) getOptNutriAtIndex: (int) i  { return optNutris[i]; } 

- (int) getVision       {  return vision; }
- (int) getMaxMR        {  return maxMR; }

//- (int) getMagInputsNum {  return magInputsNum; }

- (char *) getMagGenome {  return magGenome; }

- (float *) getNutriFracs             { return magNutriFracs; }

- (float *) getNutriStocks            { return nutriStocks; }

- (float) getStock: (int) i           { return nutriStocks[i]; }

- (float) getNutriUtil: (int) i;      { return nutriUtils[i]; }

- (int *) getEnzymes                  { return enzymes; }
- (int) getEnzymesNum                 { return enzymesNum; }
- (int) getEnzymeAt: (int) i          { return enzymes[i]; }

- (int) getEnzMag 
{ if( enzymesNum>0 ) return 1; 
  return 0; }

- (int) getHasMoved    { return hasMoved; }

- (int) getMagAge      { return magAge; }
- (float) getD         { return D; }  

- (float) getNutriValue: (int) i
{  return [nutrisList getValueAtX: xPos Y: yPos atIndex: i]; } 



- magDie;
{
  int i;

  for(i=0; i< nutrisNum; i++)							
    if( nutriStocks[i] > 0)           // leave stock containment in the world  
      [nutrisList incrementValue: nutriStocks[i]  //*magNutriFracs[i]	       
		  atX: xPos Y: yPos atIndex: i+nutrisNum ];
  [modelSwarm addTotFreeBiomCons: nutriStocks[i] atIndex: i+nutrisNum]; // upd global counter
  [world putObject: nil atX: xPos Y: yPos];
  [modelSwarm magDeath: self];
  //printf(" \t +++ ");
  return self;  
}

- (int) metabolize: (float) reqE
{
  int i;
  float takenNutri; 
  float nutriStock;

                                    // BURNING ENERGY
  for(i=0; i< nutrisNum; i++)
    if( magNutriFracs[i] > 0 )         // input mask
    {
      takenNutri = reqE / ((float)inputsNum * nutriUtils[i]);
    /*     printf("\n%d:%3.1f %d, %2.1f*%2.1f=%4.1f", 
	     i, nutriStocks[i], magInputsNum, takenNutri,nutriUtils[i],
	     takenNutri*nutriUtils[i]);*/
      if( takenNutri < 0.01 )
	takenNutri = 0.01;
      nutriStock = nutriStocks[i] - takenNutri;
      if(nutriStock == nutriStocks[i])
	printf("\n\007 !*! Mag: delta nutristock = ZERO !");
      nutriStocks[i] = nutriStock;
  //   printf("\t %3.1f", nutriStocks[i]);
      if( nutriStocks[i] <= 0 || magAge > [modelSwarm getAgeLimit]) 
      {
	[self magDie];
	return 1;
      }  
    }  
                                                           // PRODUCING NUTRI
  for(i=0; i< nutrisNum; i++)
    if( magNutriFracs[i] < 0 )     // output mask
    {
      float output = reqE * (-magNutriFracs[i]);
      [nutrisList incrementValue: output
		 atX: xPos Y: yPos atIndex: i];
      [modelSwarm addTotNutriProd: output atIndex: i];  // update global counter
    }
  return 0;     
}

- step
{
  int newX,newY, i,j, bestX, bestY;
  int absX = 999; int absY = 999;
  int minStockIndex = 0;
  float minStockValue = 0.0;
  int max, distance, dX,dY,dXY,foundMin=0, foundSpot=0, val;
  int partDist, partX, partY;
  id pointer;
  float w, sumCR, sumSpotNutri; //, d;
  double distXY, ratio;
  // int r;

  if( [modelSwarm getDeathRate] != 0 )
    if( [uniformDblRand getDoubleWithMin: 0.0 withMax: 1.0] 
	< [modelSwarm getDeathRate] )
    {
      [self magDie ];
      return self;
    }  
  //printf("\n %d %d",inputsNum,outputsNum);

  if( inputsNum==0 || outputsNum==0)   // killing Mag with 0 ins or 0 outs
  {                                    // in the nature evr. matter changes to st.
    [self magDie ];
    return self;
  }


  hasMoved = 0;
  magSize=0;                         
  magAge++;
  for(i=0; i< nutrisNum; i++)
    magSize = magSize + nutriStocks[i];        // sum all stocks
  w = pow(magSize,(*ExponP));
                                          // EATING
    /* Consumption rate depends on size of Mag and also its individual genetical
       set saying how big "byte" it has (magNutriFracs) */ 
  D = 0;  sumSpotNutri = 0;
  for(i=0; i<nutrisNum; i++)
    sumSpotNutri = sumSpotNutri + [nutrisList getValueAtX: xPos Y: yPos atIndex:i];
  for(i=0; i<nutrisNum; i++)
  {
    if( sumSpotNutri!=0 && optNutris[i]!=0 )
      D += fabs( (optNutris[i] - 
	       ([nutrisList getValueAtX: xPos Y: yPos atIndex:i])/sumSpotNutri)/optNutris[i]);
    if (optNutris[i]== 0 && sumSpotNutri!=0 )
      D += fabs( (optNutris[i] - 
	       ([nutrisList getValueAtX: xPos Y: yPos atIndex:i])/sumSpotNutri));

  }
  D = D/nutrisNum;       // scaling to <0,1>
  satisfMetab = (*KsatisfP) * D*D;
  sumCR = 0;
  for(i=0; i< nutrisNum; i++)
  {
    if( magNutriFracs[i] > 0 )         // input mask 
    {
      float singleCR =  (*KconsumP) * w * magNutriFracs[i];
      nutriStocks[i] = nutriStocks[i] + [nutrisList takeValue: singleCR 
					      atX: xPos Y: yPos atIndex: i];
      [modelSwarm addTotNutriCons: singleCR atIndex: i];   // update global counter
      sumCR = sumCR + singleCR;
    }
    if( enzymes[i]==1 )
    {
      float singleCR =  (*KconsumP) * w; 
      nutriStocks[i] = nutriStocks[i] + [nutrisList takeValue: singleCR 
 						    atX: xPos Y: yPos 
 						    atIndex: i+nutrisNum];
      [modelSwarm addTotNutriCons: singleCR atIndex: i];   // update global counter
       sumCR = sumCR + singleCR;
    }
      
  }
  consRate = sumCR/inputsNum; // for global avg value measuring

                                 // SURVIVING - basalMetab
  magSize=0;                         // Count MagSize
  for(i=0; i< nutrisNum; i++)
    magSize = magSize + nutriStocks[i];        // also nonInput nutri
  w = pow(magSize,(*ExponP));
  basalMetab  = (*KmetabP) * w;	
  basalMetab = basalMetab * (1+ satisfMetab); 
  enzMetab    = ((float)enzymesNum * (*enzCostP)) * w; 
  //  enzMetab = enzMetab * (1+satisfMetab); 
  if( [self metabolize: (basalMetab + enzMetab) ] == 1) 
    return self;				 
  //  if( basalMetab==0 ) 
  //  printf("\n\007 !*! Mag: basalMetab ZERO !");
  
                               // SEARCHING
                  // - check the emptiest stock and search for that nutrient
  foundMin=0;		      //   1st minimal stock in input mask
  for(i=0; i< nutrisNum && foundMin==0; i++)
    if( magNutriFracs[i] > 0 )         // input mask 
    {
      foundMin = 1;
      minStockIndex = i; 
      minStockValue = nutriStocks[i] * nutriUtils[i];
    }  
  if( foundMin == 0)           // if magInput = 000..0  Die!
  {
    [self magDie];
    return self;
  }  
  else              // if Mag eats st. i.e. Input != 000..0
  {  
    for(i=0; i< nutrisNum; i++)     // get Minimal Stock
      if(  magNutriFracs[i] > 0 )         // input mask 
	if( (nutriStocks[i] * nutriUtils[i]) < minStockValue )
        {	
	  minStockValue = nutriStocks[i] * nutriUtils[i];
	  minStockIndex = i;
        }
                          //   LOOK AROUND Vision x Vision for richest
			  //   spot with nutri of type = minStock 
			  //   or niomass type = minStock
    
    bestX = xPos; bestY = yPos; 
    max = 0; foundSpot = 0;
    for(i= xPos-vision ; i<= xPos+vision; i++)
    { 
      newX = (i + worldSize) % worldSize;
      for(j= yPos-vision ; j<= yPos+vision; j++)
      { 
        newY = (j + worldSize) % worldSize;
	if( (pointer=[world getObjectAtX: newX Y: newY]) == nil)
        {       // not needed skip test of self, there's also !nil
	        // if bestXY = currentXY : skip & will eat it in next step   
	  if((val=[nutrisList getValueAtX: newX Y: newY 
			      atIndex: minStockIndex]) >max)
	  {
	    bestX = newX;
	    bestY = newY;
	    absX = i; absY = j;
	    max = val;
	    foundSpot = 1;
	  }	 
  	         // if MAg has enzyme search for min type biomass too 
	  if( enzymes[minStockIndex]==1   &&
	      (val=[nutrisList getValueAtX:newX Y:newY 
			      atIndex: minStockIndex+nutrisNum]) >max )
          {
	    bestX = newX;
	    bestY = newY;
	    absX = i; absY = j;
	    max = val;
	    foundSpot = 1;
	    //  printf("%d ",minStockIndex);
	  }	 
	}
      }
    }  
  }       
                              // MOVING in direction of Best Spot
  if ( foundSpot == 1)   
  {
    magSize=0;                         // Count MagSize
    for(i=0; i< nutrisNum; i++)
      magSize = magSize + nutriStocks[i];        // also nonInput nutri
    w = pow(magSize,(*ExponP));
    dX = (intabs(xPos-bestX) < intabs(xPos-absX)) ?
           (xPos-bestX) : (xPos-absX) ; 
    dY = (intabs(yPos-bestY) < intabs(yPos-absY)) ?
           (yPos-bestY) : (yPos-absY) ; 
    dXY = intabs( intabs(dX) - intabs(dY) );  
    distXY = sqrt( dX*dX + dY*dY); 	     // realXYdist
				       // XYdistance in 8 direction space
    distance = dXY + ( intabs(dX)+intabs(dY)-dXY)/2;       

			// factors limiting step: maxMR (local)	=> use min
    if( (distance * (*KmoveP)) <= (maxMR * (*KmetabP)))   // full step
    {  
      moveMetab = distance * (*KmoveP) * w ;// moveMetab *= 1+ satisfMetab; 
      //    if( moveMetab==0 ) 
      //	printf("\n\007 !*! Mag: moveMetab ZERO !");
      if( [self metabolize: moveMetab] == 1 )  // if not enough stocks Die !
	return self;
      [world putObject: nil atX: xPos Y: yPos ];
      xPos = bestX;
      yPos = bestY;
      [world putObject: self atX: xPos Y: yPos ];
      hasMoved = 1;
    }  
    else					//partial step
    {
      partDist = (int) ( (maxMR * (*KmetabP))/ (*KmoveP));
		// check if place for partial step is empty
		// if not decrease partial step
      do{				
        ratio = (double)partDist/distance;
        partX = (int) (dX * ratio);
        partY = (int) (dY * ratio);
	newX = (partX+xPos + worldSize) % worldSize;
	newY = (partY+yPos + worldSize) % worldSize;
        if( (pointer=[world getObjectAtX: newX Y: newY]) != nil && partDist!=0)
 	  partDist -= 1;    // if target is occupied, take shorter step 
	                    // not if dist=0 when pointer will detect Mag itself
      }while(partDist > 0 && pointer!=nil);  // until dist=0 or free place 	

      moveMetab = partDist * (*KmoveP) * w; //moveMetab *= 1+ satisfMetab; 
      if( moveMetab!=0 && partDist>0 ) // if can make a step
      {
	//if( moveMetab==0 ) 
	//  printf("\n\007 !*! Mag: PartMoveMetab ZERO !");
        if( [self metabolize: moveMetab] == 1 )    // if not enough stocks Die !
	  return self;
        [world putObject: nil atX: xPos Y: yPos];
        xPos = newX;
        yPos = newY;
        [world putObject: self atX: xPos Y: yPos];
        hasMoved = 2;
      }	
//    printf("\n Partial step %d/%d=%3.2f\tpX:%d\tpY:%d\t%d:%d ",
//	partDist,distance,ratio,partX,partY,partDist,distance);
    }
    
    
// printf("\n pos:%d,%d\tabs:%d,%d\tbest:%d,%d\t d:%d,%d\tdist8:%d",
//    xPos, yPos, absX,absY,bestX,bestY, dX,dY,distance);
/*   printf("\n dist: %d possE: %d minStock %d ",distance,
    possibleEnergy,minStockIndex);
    for(i=0; i< nutrisNum; i++)
      printf("%d ",nutriStocks[i]); */
  }  
/*  printf("\n after:\n ");
  for(i=0; i< nutrisNum; i++)
    printf("%d ",nutriStocks[i]);*/

  magSize=0;                         // REPRODUCING
  for(i=0; i< nutrisNum; i++)
    magSize = magSize + nutriStocks[i];        // sum all stocks
  if( magSize > [modelSwarm getReproSize] )     
    [modelSwarm magBirth: self];

  if(enzymesNum > 0 )          // extra color code for enzyme producers
    hasMoved += 5;
  satisfMetab = basalMetab * satisfMetab;
  return self;
}

- drawSelfOn: (id <Raster>)r
{
  switch( hasMoved )
  { case 1:			// full step
	    [r drawPointX: xPos Y: yPos Color: 2];
	    return self;	
	    break;	
    case 2:			// partial step
	    [r drawPointX: xPos Y: yPos Color: 4];
	    return self;
	    break;
    case 5:			// enzyme producer 
            if( magAge < 1)
	      [r drawPointX: xPos Y: yPos Color: 5];  // bioNew
	    else
	      [r drawPointX: xPos Y: yPos Color: 6];  //bioStatic
	    return self;
	    break;
    case 6:			// enzyme producer - bio full step
	    [r drawPointX: xPos Y: yPos Color: 7];
	    return self;
	    break;
    case 7:			// enzyme producer - bio partial step
	    [r drawPointX: xPos Y: yPos Color: 8];
	    return self;
	    break;
  }

  // else (no hasMove flag) :
  if( magAge < 1)                               // New
    [r drawPointX: xPos Y: yPos Color: 3];
  else                                          // Static
    [r drawPointX: xPos Y: yPos Color: 1];


  /*   // old:  X eater and producer color coding 
  if( (magInput%2)==1 )     // i.e. eating A  
    [r drawPointX: xPos Y: yPos Color: 6];
  else
    if( (magOutput%2)==1 )     // i.e. producing A  
      [r drawPointX: xPos Y: yPos Color: 5];
    else 
      [r drawPointX: xPos Y: yPos Color: 1];*/    // otherwise
  return self;
}

@end

/*
Copy of color coding from ObserverSwarm :

  [colorMap setColor: 0 ToName: "black"];
  [colorMap setColor: 1 ToRed: 0.6 Green: 0.7 Blue: 1];   // static mag
  [colorMap setColor: 2 ToRed: 1 Green: 0.6 Blue: 1];   // moving mag-full
  [colorMap setColor: 3 ToRed: 0.7 Green: 0.9 Blue: 0.5];   // new mag
  [colorMap setColor: 4 ToRed: 0.7 Green: 0.0 Blue: 0];   // moving mag-partial
  [colorMap setColor: 5 ToName: "green"];    // bioNew
  [colorMap setColor: 6 ToName: "blue"];     // bioStatic
  [colorMap setColor: 7 ToName: "magenta"];  // bioFullstep
  [colorMap setColor: 8 ToName: "red"];      // bio Part step



old coding:
  [colorMap setColor: 255 ToRed: 0.6 Green: 0.7 Blue: 1];   // static mag
  [colorMap setColor: 254 ToRed: 1 Green: 0.6 Blue: 1];   // moving mag-full
  [colorMap setColor: 253 ToRed: 0.7 Green: 0.9 Blue: 0.5];   // new mag
  [colorMap setColor: 252 ToRed: 1 Green: 0.0 Blue: 0];   // moving mag-partial
  [colorMap setColor: 251 ToName: "green"];    // X producer
  [colorMap setColor: 250 ToName: "red"];      // X eater

*/









