// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/* Space with multiple dicrete2d layers */

#import <space.h>	
#import <objectbase/SwarmObject.h>	
#import <collections.h>
#import <space/Diffuse2d.h>	
#import <objectbase.h>	


@interface MultiDiscrete2d: SwarmObject {
  id gridList;
  int maxSpotNutri;
  int ioUnit;
}

-createGridsN: (int) num sizeX: (int)x sizeY: (int)y 
                    withDiffusion: (double) diffusion 
		    withEvaporation: (double) evaporation; 
-getId: (int)index;
-(int) getM2dSizeX;
-(int) getM2dSizeY;
-(int) getValueAtX: (int) x Y: (int) y atIndex: (int) i;
-(int) getTotalAtIndex: (int) i;
-(int) getMaxSpotNutri;
- setMaxSpotNutri: (int) max; 
- setIOUnit: (int) u; 
- putValue: (int) v atX: (int) x Y: (int) y atIndex: (int) i;
- putValueUpd: (int) v atX: (int) x Y: (int) y atIndex: (int) i;
- (int) incrementValue: (int) delta atX: (int) x Y: (int) y atIndex: (int) i;
- (int) takeValue: (int)val atX: (int) x Y: (int) y atIndex: (int) i;
- (int) incrementValueUpd: (int)delta atX: (int)x Y: (int)y atIndex: (int)i;
- (int) takeValueUpd: (int)val atX: (int) x Y: (int) y atIndex: (int) i;
- (int) updateInFlowBy: (int) val atIndex: (int) i;
- (int) updateOutFlowBy: (int) val atIndex: (int) i;
- (int) updateInFlowByProb: (double) prob atIndex: (int) i;
- (int) updateOutFlowByProb: (double) prob atIndex: (int) i;

@end


