// Metabolizing Agents. Copyright (C) 1998-1999 Peter Zvirinsky
// This program is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/* Space with multiple discrete2d layers */

#import "MultiDiscrete2d.h"
#import "Resource2d.h"
#import <space/Diffuse2d.h>	
#import <random.h>
//#define maxSpotNutri 25
#define MaxTry 1000

@implementation MultiDiscrete2d

-createGridsN: (int) num sizeX: (int)x sizeY: (int)y 
                    withDiffusion: (double) diffusion 
		    withEvaporation: (double) evaporation 
{
  Resource2d *d2d;
  int n;
  
  gridList = [List create: [self getZone]];
  for (n=0; n < num; n++)
  {
    d2d = [Resource2d createBegin: [self getZone]];
    [d2d setSizeX: x Y: y];  
    [d2d setDiffusionConstant: diffusion];
    [d2d setEvaporationRate: evaporation];
    d2d = [d2d createEnd];
    [gridList addLast: d2d]; // add to the collection
   }
  return self;  
}

-(int) getMaxSpotNutri
{  return maxSpotNutri; }

- setMaxSpotNutri: (int) max
{ maxSpotNutri = max; return self; }

- setIOUnit: (int) u
{ ioUnit = u; return self; }

-getId: (int) index{
  if( index > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: getId: too big index\n"];
  return [gridList atOffset: index];
}
  
-(int) getM2dSizeX 
{
  Resource2d *d2d;
  d2d = [gridList atOffset: 0];
  return [d2d getSizeX];   
}

-(int) getM2dSizeY 
{
  Resource2d *d2d;

  d2d = [gridList atOffset: 0];
  return [d2d getSizeY];   
}

-(int) getValueAtX: (int) x Y: (int) y atIndex: (int) i
{
  Resource2d *d2d;
  
  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: getValue: too big index\n"];
  d2d = [gridList atOffset: i];
  if (d2d) return [d2d getValueAtX: x Y: y];
  else return 0;
}

-(int) getTotalAtIndex: (int) i
{
  Resource2d *d2d;
  int sum=0, x, y, xSize, ySize;
 
  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: getTotalIndex: too big index\n"];
  d2d = [gridList atOffset: i];
  xSize = [d2d getSizeX];
  ySize = [d2d getSizeY];
  for( x=0; x<xSize ; x++)
    for( y=0; y<ySize ; y++)
      sum += [d2d getValueAtX: x Y: y];
  return sum;
}

- putValue: (int) v atX: (int) x Y: (int) y atIndex: (int) i 
{
  Resource2d *d2d;
  
  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: putValue: too big index\n"];
  d2d = [gridList atOffset: i];
  [d2d putValue: v atX: x Y: y];
  return self;
}

//=========== as putVALUE + updates layers of Diffuse2d space ==========

- putValueUpd: (int) v atX: (int) x Y: (int) y atIndex: (int) i 
{
  Resource2d *d2d;
  
  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: putValue: too big index\n"];
  d2d = [gridList atOffset: i];
  [d2d putValue: v atX: x Y: y];
  [d2d updateLattice];                   // <<<=== crucial !
  return self;
}

-(int) incrementValue: (int) delta atX: (int) x Y: (int) y atIndex: (int) i
{
  Resource2d *d2d;
  int newVal, oldVal;

  oldVal = [self getValueAtX: x Y: y atIndex: i];
  newVal = delta + oldVal;
  if( newVal > maxSpotNutri )
  {
    [self putValue: maxSpotNutri atX:x Y: y atIndex: i];
    return (maxSpotNutri-oldVal);
  }
  [self putValue: newVal atX:x Y: y atIndex: i];
  return delta;       // return value that it could put down      
}

- (int) takeValue: (int) reqVal atX: (int) x Y: (int) y atIndex: (int) i
{
  int realVal, newVal;

  realVal = [self getValueAtX: x Y: y atIndex: i];
  if( realVal < reqVal )          // if asked more than exist give max
    reqVal = realVal;
  [self putValue: realVal-reqVal atX: x Y: y atIndex: i];
  
  if( reqVal < 0)
    [InvalidCombination raiseEvent:"Multi2d: takeValue: negative nutri!\n"];
  return reqVal;     // returns value it took 
}


//=========== increments and updates layers of Diffuse2d space ==========

-(int) incrementValueUpd: (int) delta atX: (int) x Y: (int) y atIndex: (int) i
{
  Resource2d *d2d;
  int newVal, oldVal;

  oldVal = [self getValueAtX: x Y: y atIndex: i];
  newVal = delta + oldVal;
  if( newVal > maxSpotNutri )
  {
    [self putValueUpd: maxSpotNutri atX:x Y: y atIndex: i];
    return (maxSpotNutri-oldVal);
  }
  [self putValueUpd: newVal atX:x Y: y atIndex: i];
  return delta;       // return value that it could put down      
}


//=========== decrements and updates layers of Diffuse2d space ==========

- (int) takeValueUpd: (int) reqVal atX: (int) x Y: (int) y atIndex: (int) i
{
  int realVal, newVal;

  realVal = [self getValueAtX: x Y: y atIndex: i];
  if( realVal < reqVal )          // if asked more than exist give max
    reqVal = realVal;
  [self putValueUpd: realVal-reqVal atX: x Y: y atIndex: i];
  
  if( reqVal < 0)
    [InvalidCombination raiseEvent:"Multi2d: takeValue: negative nutri!\n"];
  return reqVal;     // returns value it took 
}


//===========   adds units to space at random positions     =============
//===========    using 'rulette' system                     =============

-(int) updateInFlowBy: (int) val atIndex: (int) i;
{
  int k,x,y,size, currVal, putVal, done;
  long sum, sumAll, randPointer, maxSum, availSpace;
  
  //  printf("\n I%d v:%d ",i,val);
  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: updInFlow: too big index\n"];
  if( val == 0)
    return 0;
  sumAll = (long) [self getTotalAtIndex: i];
  size = [self getM2dSizeX];
  maxSum = size*size * maxSpotNutri;
  availSpace = maxSum - sumAll;
  //  printf("\tsumAll:%d s:%d maxSum:%d avail:%d",sumAll,size,maxSum,availSpace);
  if( availSpace < val) 
  {
    printf("\nInFlow: Req Val to add in nutri:%d too big, setting reqVal=availSpace=%d",
	   i,availSpace);
    val=availSpace;
  }
  currVal = val;
  while(currVal>0)
  {
    done = 0; sum = 0;
    randPointer=[uniformDblRand getDoubleWithMin: 0 withMax: availSpace-1];
    //    printf("\n currVal:%d, rand:%d",currVal,randPointer);
    for (y = 0; y < size && done == 0; y++) 
      for (x = 0; x < size && done == 0; x++) 
      {  
	sum += maxSpotNutri-[self getValueAtX: x Y: y atIndex: i];
	if( sum > randPointer )
	{ 
	  putVal=[self incrementValueUpd: 10 atX: x Y: y atIndex: i];
	  currVal -= putVal;
	  if(putVal==0)
	    printf("\n Put %d!!! i:%d, v:%d",putVal,i,currVal);
	  availSpace -= putVal;
	  done = 1;
	}
      }
  }
  //  printf("\n+++++ i:%d currVal:%d",i,currVal);
  if(currVal>0)
    printf("\n InFlow not 100%% putValue: %d i:%d,req val:%d",currVal,i,val);
  //  printf("\t\t\t..Done");
  return val-currVal;           // return value that was really put down 
}


//===========  takes units to space from random positions     =============
//===========    using 'rulette' system                       =============

-(int) updateOutFlowBy: (int) val atIndex: (int) i
{
  int k,x,y,size, currVal, takenVal, done;
  long sum, sumAll, randPointer;
  
  if( i > [gridList getCount])
    [InvalidCombination raiseEvent:"Multi2d: updOutFlow: too big index\n"];
  if( val == 0)
    return 0;
  sumAll = (long) [self getTotalAtIndex: i];
  val = ((double)val/100.0) * sumAll;
  //  printf("\n Out:%d, sumAll before:%d  val:%d",i,sumAll,val);
  if(sumAll < val) 
  {
    printf("\nOutFlow: Req Val to take in nutri:%d too big, setting reqVal=sumAll=%d",i,sumAll);
    val=sumAll;
  }
  currVal = val;
  size = [self getM2dSizeX];
  while(currVal>0)
  {
    done = 0; sum = 0;
    randPointer=[uniformDblRand getDoubleWithMin: 0 withMax: sumAll-1];
    for (y = 0; y < size && done == 0; y++) 
      for (x = 0; x < size && done == 0; x++) 
      {  
	sum += [self getValueAtX: x Y: y atIndex: i];
	if( sum > randPointer )
	{ 
	  takenVal = [self takeValueUpd: 10 atX: x Y: y atIndex: i];
	  currVal -= takenVal;
	  if(takenVal==0)
	    printf("\n Taken %d!!! i:%d, v:%d",takenVal,i,currVal);
	  sumAll -= takenVal;
	  done = 1;
	}
      }
  }
  if(currVal>0)
    printf("\nOutFlow not 100%% takenValue: %d i:%d,req val:%d",currVal,i,val);
  //  printf("\nOut:%d d: %d curr:%d",i,val-currVal,currVal);
  return val-currVal;      // return value that it really took out
}


-(int) updateInFlowByProb: (double) prob atIndex: (int) i;
{
  int x,y,size, time=0, putVal, notdone,putCnt, cannot;
  double area;
 
  if( prob == 0)
    return 0;
  notdone=0; putCnt=0; cannot=0;
  size = [self getM2dSizeX];
  area = size * size;
  prob = prob/100.0;
  for (y = 0; y < size; y++) 
    for (x = 0; x < size; x++) 
    {  
      if ( (putVal=[self getValueAtX: x Y: y atIndex: i]) < maxSpotNutri )
      {
	//	prob = prob + cannot/area;
	if ([uniformDblRand getDoubleWithMin: 0.0 withMax: 1.0] < prob) 
	  putVal = [self incrementValue: 1 atX: x Y: y atIndex: i];
      }
      else
	cannot++;
      //      printf("\n InF%d: prob: %5.3f cannot:%d val:%d",i,prob,cannot,putVal);
    }  
  if( cannot > 0)
    printf("\n Cannot put req InFlow at %d \t%4.2f%% refused ",
	   i,100*cannot/area);
  return 0;
}

-(int) updateOutFlowByProb: (double) prob atIndex: (int) i
{
  int x,y,size, takenVal, notdone,tookCnt, cannot;
  double area;

  if( prob == 0)
    return 0;
  notdone=0; tookCnt=0;cannot =0;
  size = [self getM2dSizeX];
  area = size * size; 
  prob = prob/100.0;
  for (y = 0; y < size; y++) 
    for (x = 0; x < size; x++) 
    {  
      if ([self getValueAtX: x Y: y atIndex: i] > 0 )
      {
	//	prob = prob + cannot/area;
	if ([uniformDblRand getDoubleWithMin: 0.0 withMax: 1.0] < prob) 
	  takenVal = [self takeValue: 1 atX: x Y: y atIndex: i];
      }  
      else
	cannot++;
    }
  if( cannot > 0)
    printf("\n Cannot take req OutFlow at %d \t%4.2f%%",
	   i,100*cannot/area);
  return 0;
}


@end

// ---------------------------- GraveYard of old functions :) -----------

/*
- updateInFlowBy: (int) val atIndex: (int) i;
{
  int x,y,size, time=0, putVal, mxTry;

  //  printf("\n Asked%d:%d",i,val);
  if( val == 0)
    return self;
  mxTry = val * 5;
  size = [self getM2dSizeX]-1;
  while( !( val<=0 || time>mxTry) )
  {
    x = [uniformIntRand getIntegerWithMin: 0 withMax: size];
    y = [uniformIntRand getIntegerWithMin: 0 withMax: size];
    putVal=[self incrementValue: 10 atX: x Y: y atIndex: i];
    val = val - putVal;
    time ++;
  }
  if(val > 0)
    printf("\n Cannot put req InFlow at %d, rest= %d %dx try",i,val,time);
  return self;
}

- updateOutFlowBy: (int) val atIndex: (int) i
{
  int x,y,size, time=0,mxTry;

  if( val == 0)
    return self;
  size = [self getM2dSizeX]-1;
  mxTry = (size+1)*(size+1);        
  while( ! (val<=0  || time>mxTry) )
  {
    x = [uniformIntRand getIntegerWithMin: 0 withMax: size];
    y = [uniformIntRand getIntegerWithMin: 0 withMax: size];
    val = val - [self takeValue: val atX: x Y: y atIndex: i];
    time ++;
  }
  if(val > 0)
    printf("\n Cannot take req OutFlow at %d, rest= %d %dx try ",i,val,time);
  return self;
}

*/
