// 	$Id: BoolNode.h,v 1.6 1997/07/10 13:32:39 complex Exp $	

#define MAX_PERIODICITY 7

#import <graph.h>

@interface BoolNode: DiGraphNode {

  BOOL state[MAX_PERIODICITY*2];    // maintain a state history - to define attractors!

  BOOL newState;                    // don't have graph buffered at the moment - so use a temp var
  int function;                     // Boolean function used to calculate new state
  
  int boolId;                       // numerical ID of Boolean node (used to uniquely identify this node)
  int periodicity;                  // classifies the periodicity of the node

  id inputLink ;                    // input hardwired links from other Boolean objects...
  id boolNet ;                      // Boolean network it is a part of...
}

-setBoolFunc: (int) bf;             // set the boolean function type for the element
-setEntityId: (int) the_name;
-makeLinkFrom:  aNode ;             // create a link from "aNode"
-makeLinkFromWithInt: (int) aNumber ; // create a link from node with number "aNumber"

-createEnd;

-(int) getBoolFunc;
-setBoolNet: aBoolNet ;

-(BOOL) getBoolState;               // get the current state of the element
-displayNodeState;                  // updates the display of the node on the "canvas"
-setBoolState: (BOOL) state;	    // force the element's Boolean state

-(const char *) getInstanceName;
-(int) getInstanceNumber;

-(int) getNumInputs;                // gets the number of inputs this particular node receives...
-(int) getNumOutputs;               // gets the number of outputs this particular node sends...
-stepRule ;                         // each element can handle the calculation of it's new state
-update ;                           // updates the state of the Boolean network (takes the place of buffering)
                                    // called after stepRule
-(int) updatePeriodicity;

@end
