#define __USE_FIXED_PROTOTYPES__  // for gcc headers

#import <math.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#import <simtools.h>
#import <objc/objc-api.h>
#import <graph.h>

#import <booleannet.h>

@implementation BoolNode

- setBoolFunc: (int)bf 
{ // set the boolean function type for the element
  function = bf;
  return self;
}
// offer two methods to add a link 
// one via the actual node, the other via an integer index

// create a link to the current node using the element itself
- makeLinkFrom: aNode 
{           
  [super makeLinkFrom: aNode];
  return self;
}

// create a link to the current node using an integer index
- makeLinkFromWithInt: (int)aNumber 
{  
   id entityList, entity, index, aNode;

   entityList = [boolNet getNodeList]; // get the list of nodes

   // need to search the entity list to find the correct node to make link to

   index = [entityList begin: globalZone] ;
   while ( (entity = [index next]) ) {
     if ([entity getInstanceNumber] == aNumber) {
       aNode = entity;
       [self makeLinkFrom: aNode];     // found it! - make a link to it!
     }
     else {   
       // couldn't find it - should do something here 
       // to let user know an error has been made!!
     }
   }
   return self ;
}

- setEntityId: (int)theId 
{
  char *the_name ;  
  boolId = theId;                          // set the Boolean id
  the_name = malloc(10) ;                  // create a name for each element
  sprintf(the_name, "Bool%d", theId) ;

  [self setNodeLabel: the_name];
  return self ;
}

// create-time messages...

- placeX: (int)x Y: (int)y 
{
   // move to appropriate position on canvas...
   int currX, currY;
   int deltX, deltY;

   // if (canvas)
   //  trace(3, "value of canvas is non-zero");
   // else
   //   trace(3, "value of canvas is zero");
      
   if (canvas) {
      currX = [nodeItem getX];
      deltX = x - currX;
      currY = [nodeItem getY];
      deltY = y - currY;
      // trace(3, "moving %s from (%d,%d) by (%d,%d)\n", 
      //   label, currX, currY, deltX, deltY);
      [nodeItem initiateMoveX: (x - currX) Y: (y - currY)] ;
   }
   return self ;
}

- createEnd 
{
  [super createEnd] ;
  return self ;
}

- (int)getBoolFunc 
{
  return function;
}

- setBoolNet: aBoolNet 
{
  boolNet = aBoolNet ;
  return self ;
}
- (int)getPeriodicity 
{              // gets the periodicity of the node
  return periodicity;
}

- (const char *)getInstanceName 
{
  return label ;
}

- (int)getInstanceNumber 
{
  return boolId;
}

- (BOOL)getBoolState 
{  // get the Boolean state of the element
  return state[0];
}

- displayNodeState {
  int attractor;  
  attractor = [self updatePeriodicity];        // update the attractor type
 
  // colours the node according to state
  if (canvas) {        // if in "interactive" mode
    if (state[0]) {   // if "ON" 
      [[nodeItem setBorderColor: "blue"] setBorderWidth: 3] ;
    }
    else {
      [[nodeItem setBorderColor: "black"] setBorderWidth: 3]  ;
    }
    switch (attractor) {    

    case 7: 
      [nodeItem setColor: "yellow"];
      break;   
    case 6: 
      [nodeItem setColor: "pink"];
      break;   
    case 5: 
      [nodeItem setColor: "grey"];
      break; 
    case 4: 
      [nodeItem setColor: "orange"];
      break; 
    case 3: 
      [nodeItem setColor: "brown"];
      break; 
    case 2: 
      [nodeItem setColor: "purple"];
      break; 
    case 1: 
      [nodeItem setColor: "red"];
      break; 
    case 0: 
      [nodeItem setColor: "white"];
      break;
    default:
      [nodeItem setColor: "white"];
      break;
    }
    GUI_UPDATE_IDLE_TASKS ();
  }
  return self;
}

- setBoolState: (BOOL)s 
{
  int i;

  // update the Boolean node's history...
  for ( (i = (MAX_PERIODICITY*2) - 1) ; i > 0 ; i--) 
    state[i] = state[i - 1];	
  state[0] = s;                      // set Boolean state
 
  return self;
}

- getInputLinks 
{
  return fromList;
}

- dropLinks 
{
  id  index, link;

  index = [fromList begin: globalZone];
  [index setLoc: Start];

  while ( (link = [index next]) ) {
    [index remove];
    [fromList remove: link];
    [link drop];
  }
  [index drop];

  return self;
}

- (int)getNumInputs 
{  
  id  link, index, node;
  int numInputs = 0; 

  index = [fromList begin: globalZone] ;
  // trace(3, "%s is connected to :", [self getInstanceName]);
  
  while( (link = [index next]) ){
    node = [link getFrom] ;             // get node
    // trace(3, "%s", [node getInstanceName]);
    numInputs++;
  }
  [index drop]; 

  return numInputs;
}

- (int)getNumOutputs 
{  
  id  link, index, node;
  int numOutputs = 0;

  index = [toList begin: globalZone] ;

  while( (link = [index next]) ){
    node = [link getFrom] ;             // get node
    numOutputs++;
  }
  [index drop]; 

  return numOutputs;
}

- stepRule 
{              // actual Boolean network behavoir
  id  link, index, node;
  BOOL inputState;
  int nodeNum;
  int arrayIndex;       
  // index into the array to calculate the output of the Boolean function
  // this is converted from a K-tuple into a bit offset 

  index = [fromList begin: globalZone] ;
  link = [index next];                 // get value of first input node
  
  nodeNum = 0;
  arrayIndex = 0;

  if (link != nil) {                   // ignore if no input links
    node = [link getFrom] ;            // get node
    arrayIndex = [node getBoolState];  // interrogate node's state

    // trace(3, "input state of the %d-th node = %d, arrayIndex now =
    // %d", nodeNum, arrayIndex, arrayIndex);

    nodeNum++;                         // increment the node number

    // step through list of connections to myself
    while ( (link = [index next]) ){
      node = [link getFrom] ;             // get node
      inputState = [node getBoolState];   // interrogate node's state
          
      arrayIndex = ldexp(inputState, nodeNum) + arrayIndex; 

      // trace(3, "input state of the %d-th node = %d, arrayIndex now
      // = %d", nodeNum, inputState, arrayIndex);

      nodeNum++;                          // look at the next node

    }
    [index drop]; 
    
    // this part functions as a look-up table for the Boolean function
    // and the input K-tuple by using the bit offset arrayIndex 
    // bit shift right by arrayIndex and bit-AND with one for the 
    // desired result

    newState = ( function >> arrayIndex & 1 );  // also set the new state 
                                                //ready for the next transition

    // trace(3, "function = %d, arrayIndex = %d and newState = %d", 
    //   function, arrayIndex, newState);

  }
  return self;
}

- (int)updatePeriodicity 
{  // classify attractor...

  int i;
  int p = 1;               // start looking for point attractors (period-1)
  periodicity = -1;        // initialise the periodicity to something undefined
  
  // check the Boolean nodes history...
  while ((periodicity == -1) && (p <= MAX_PERIODICITY)) {     
     // while the node has not yet been classified...
    i = 0;
    do {
      if (state[i] == state[i+p]) 
	periodicity = p;   // period found! 
                           // continue looking until this period doesn't match
      else
	periodicity = -1;        // no match - exit loop
      i++;
    }
    while ( (i <= (2*MAX_PERIODICITY - p - 1)) && (periodicity != -1) );
    p++;           // periodicity must be greater... up the ante 
  }
  
  if (periodicity == 1)     // 1-periodicity does not 
                            // include a history all zeroes...
    if (state[0] == 0)
      periodicity = 0;
  
  return periodicity;
}

- update 
{     // updates the state of the node, synchronously

  [self setBoolState: newState];   // set myself into a new Boolean state
  [self displayNodeState];         // update "look of the node"

  newState = 0;    // resets new State
  return self;
}

@end










